/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.exposers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.identification.JarIdentification;
import org.apache.maven.shared.jar.identification.JarIdentificationExposer;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.io.IOUtil;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class TextFileExposer
extends AbstractLogEnabled
implements JarIdentificationExposer {
    public void expose(JarIdentification identification, JarAnalyzer jarAnalyzer) {
        List textFiles = this.findTextFileVersions(jarAnalyzer);
        if (!textFiles.isEmpty()) {
            for (String ver : textFiles) {
                identification.addVersion(ver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List findTextFileVersions(JarAnalyzer jarAnalyzer) {
        ArrayList<String> textVersions = new ArrayList<String>();
        List hits = jarAnalyzer.getVersionEntries();
        for (JarEntry entry : hits) {
            if (entry.getName().endsWith(".class")) continue;
            this.getLogger().debug("Version Hit: " + entry.getName());
            InputStream is = null;
            try {
                is = jarAnalyzer.getEntryInputStream(entry);
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = br.readLine();
                this.getLogger().debug(line);
                if (!StringUtils.isNotEmpty((String)line)) continue;
                textVersions.add(line);
            }
            catch (IOException e) {
                this.getLogger().warn("Unable to read line from " + entry.getName(), (Throwable)e);
            }
            finally {
                IOUtil.close((InputStream)is);
            }
        }
        return textVersions;
    }
}

