/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.compression.CompressionPool;
import org.eclipse.jetty.util.compression.InflaterPool;

public class GZIPContentDecoder
implements Destroyable {
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private final List<RetainableByteBuffer> _inflateds = new ArrayList<RetainableByteBuffer>();
    private final ByteBufferPool _pool;
    private final int _bufferSize;
    private CompressionPool.Entry _inflaterEntry;
    private Inflater _inflater;
    private State _state;
    private int _size;
    private long _value;
    private byte _flags;
    private RetainableByteBuffer _inflated;

    public GZIPContentDecoder() {
        this(null, 2048);
    }

    public GZIPContentDecoder(int bufferSize) {
        this(null, bufferSize);
    }

    public GZIPContentDecoder(ByteBufferPool byteBufferPool, int bufferSize) {
        this(new InflaterPool(0, true), byteBufferPool, bufferSize);
    }

    public GZIPContentDecoder(InflaterPool inflaterPool, ByteBufferPool byteBufferPool, int bufferSize) {
        this._inflaterEntry = inflaterPool.acquire();
        this._inflater = (Inflater)this._inflaterEntry.get();
        this._bufferSize = bufferSize;
        this._pool = byteBufferPool != null ? byteBufferPool : ByteBufferPool.NON_POOLING;
        this.reset();
    }

    public RetainableByteBuffer decode(ByteBuffer compressed) {
        this.decodeChunks(compressed);
        if (this._inflateds.isEmpty()) {
            if (this._inflated == null || !this._inflated.hasRemaining() || this._state == State.CRC || this._state == State.ISIZE) {
                return this.acquire(0);
            }
            RetainableByteBuffer result = this._inflated;
            this._inflated = null;
            return result;
        }
        this._inflateds.add(this._inflated);
        this._inflated = null;
        int length = this._inflateds.stream().mapToInt(RetainableByteBuffer::remaining).sum();
        RetainableByteBuffer result = this.acquire(length);
        for (RetainableByteBuffer buffer : this._inflateds) {
            BufferUtil.append((ByteBuffer)result.getByteBuffer(), (ByteBuffer)buffer.getByteBuffer());
            buffer.release();
        }
        this._inflateds.clear();
        return result;
    }

    protected boolean decodedChunk(RetainableByteBuffer chunk) {
        chunk.retain();
        if (this._inflated != null) {
            this._inflateds.add(this._inflated);
        }
        this._inflated = chunk;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void decodeChunks(ByteBuffer compressed) {
        RetainableByteBuffer buffer = null;
        try {
            block30: while (true) {
                block45: {
                    switch (this._state.ordinal()) {
                        case 0: {
                            this._state = State.ID;
                            break;
                        }
                        case 7: {
                            if ((this._flags & 4) == 4) {
                                this._state = State.EXTRA_LENGTH;
                                this._size = 0;
                                this._value = 0L;
                                break;
                            }
                            if ((this._flags & 8) == 8) {
                                this._state = State.NAME;
                                break;
                            }
                            if ((this._flags & 0x10) == 16) {
                                this._state = State.COMMENT;
                                break;
                            }
                            if ((this._flags & 2) == 2) {
                                this._state = State.HCRC;
                                this._size = 0;
                                this._value = 0L;
                                break;
                            }
                            this._state = State.DATA;
                            continue block30;
                        }
                        case 13: {
                            break block45;
                        }
                    }
                    if (!compressed.hasRemaining()) {
                        return;
                    }
                    byte currByte = compressed.get();
                    switch (this._state.ordinal()) {
                        case 1: {
                            this._value += (long)((currByte & 0xFF) << 8 * this._size);
                            ++this._size;
                            if (this._size != 2) continue block30;
                            if (this._value != 35615L) {
                                throw new ZipException("Invalid gzip bytes");
                            }
                            this._state = State.CM;
                            continue block30;
                        }
                        case 2: {
                            if ((currByte & 0xFF) != 8) {
                                throw new ZipException("Invalid gzip compression method");
                            }
                            this._state = State.FLG;
                            continue block30;
                        }
                        case 3: {
                            this._flags = currByte;
                            this._state = State.MTIME;
                            this._size = 0;
                            this._value = 0L;
                            continue block30;
                        }
                        case 4: {
                            ++this._size;
                            if (this._size != 4) continue block30;
                            this._state = State.XFL;
                            continue block30;
                        }
                        case 5: {
                            this._state = State.OS;
                            continue block30;
                        }
                        case 6: {
                            this._state = State.FLAGS;
                            continue block30;
                        }
                        case 8: {
                            this._value += (long)((currByte & 0xFF) << 8 * this._size);
                            ++this._size;
                            if (this._size != 2) continue block30;
                            this._state = State.EXTRA;
                            continue block30;
                        }
                        case 9: {
                            --this._value;
                            if (this._value != 0L) continue block30;
                            this._flags = (byte)(this._flags & 0xFFFFFFFB);
                            this._state = State.FLAGS;
                            continue block30;
                        }
                        case 10: {
                            if (currByte != 0) continue block30;
                            this._flags = (byte)(this._flags & 0xFFFFFFF7);
                            this._state = State.FLAGS;
                            continue block30;
                        }
                        case 11: {
                            if (currByte != 0) continue block30;
                            this._flags = (byte)(this._flags & 0xFFFFFFEF);
                            this._state = State.FLAGS;
                            continue block30;
                        }
                        case 12: {
                            ++this._size;
                            if (this._size != 2) continue block30;
                            this._flags = (byte)(this._flags & 0xFFFFFFFD);
                            this._state = State.FLAGS;
                            continue block30;
                        }
                        case 14: {
                            this._value += (long)((currByte & 0xFF) << 8 * this._size);
                            ++this._size;
                            if (this._size != 4) continue block30;
                            this._state = State.ISIZE;
                            this._size = 0;
                            this._value = 0L;
                            continue block30;
                        }
                        case 15: {
                            this._value |= ((long)currByte & 0xFFL) << 8 * this._size;
                            ++this._size;
                            if (this._size != 4) continue block30;
                            if (this._value != (this._inflater.getBytesWritten() & 0xFFFFFFFFL)) {
                                throw new ZipException("Invalid input size");
                            }
                            this.reset();
                            return;
                        }
                    }
                    throw new ZipException();
                }
                while (true) {
                    if (buffer == null) {
                        buffer = this.acquire(this._bufferSize);
                    }
                    try {
                        ByteBuffer decoded = buffer.getByteBuffer();
                        int pos = BufferUtil.flipToFill((ByteBuffer)decoded);
                        this._inflater.inflate(decoded);
                        BufferUtil.flipToFlush((ByteBuffer)decoded, (int)pos);
                    }
                    catch (DataFormatException x) {
                        throw new ZipException(x.getMessage());
                    }
                    if (buffer.hasRemaining()) {
                        boolean stop = this.decodedChunk(buffer);
                        buffer.release();
                        buffer = null;
                        if (!stop) continue;
                        return;
                    }
                    if (this._inflater.needsInput()) {
                        if (!compressed.hasRemaining()) {
                            return;
                        }
                        this._inflater.setInput(compressed);
                        continue;
                    }
                    if (this._inflater.finished()) break;
                }
                this._state = State.CRC;
                this._size = 0;
                this._value = 0L;
            }
        }
        catch (ZipException x) {
            throw new RuntimeException(x);
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    private void reset() {
        this._inflater.reset();
        this._state = State.INITIAL;
        this._size = 0;
        this._value = 0L;
        this._flags = 0;
    }

    public void destroy() {
        this._inflaterEntry.release();
        this._inflaterEntry = null;
        this._inflater = null;
    }

    public boolean isFinished() {
        return this._state == State.INITIAL;
    }

    public RetainableByteBuffer acquire(int capacity) {
        if (capacity == 0) {
            return RetainableByteBuffer.EMPTY;
        }
        return this._pool.acquire(capacity, false);
    }

    private static enum State {
        INITIAL,
        ID,
        CM,
        FLG,
        MTIME,
        XFL,
        OS,
        FLAGS,
        EXTRA_LENGTH,
        EXTRA,
        NAME,
        COMMENT,
        HCRC,
        DATA,
        CRC,
        ISIZE;

    }
}

