/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.solon.integration;

import org.apache.ibatis.solon.annotation.Db;
import org.apache.ibatis.solon.integration.MybatisAdapterManager;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.data.datasource.DsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbBeanBuilderImpl
extends DsBuilder<Db> {
    static final Logger log = LoggerFactory.getLogger(DbBeanBuilderImpl.class);

    public DbBeanBuilderImpl() {
        super(Db::value);
        this.addHandler(this::buildHandle);
    }

    public boolean buildHandle(Class<?> clz, BeanWrap dsBw) {
        if (!clz.isInterface()) {
            log.warn("Db builder is no longer supported, class: {}", (Object)clz.getName());
            Object raw = MybatisAdapterManager.get(dsBw).getMapper(clz);
            dsBw.context().wrapAndPut(clz, raw);
            return true;
        }
        return false;
    }
}

