/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.smartboot.http.common.codec.h2.codec.Http2Frame;
import org.smartboot.socket.transport.WriteBuffer;

public class SettingsFrame
extends Http2Frame {
    public static final int TYPE = 4;
    public static final int ACK = 1;
    private int headerTableSize = 4096;
    private int enablePush = 1;
    private int maxConcurrentStreams = Integer.MAX_VALUE;
    private int initialWindowSize = 65535;
    private int maxFrameSize = 16384;
    private int maxHeaderListSize = -1;
    public static final short HEADER_TABLE_SIZE = 1;
    public static final short ENABLE_PUSH = 2;
    public static final short MAX_CONCURRENT_STREAMS = 3;
    public static final short INITIAL_WINDOW_SIZE = 4;
    public static final short MAX_FRAME_SIZE = 5;
    public static final short MAX_HEADER_LIST_SIZE = 6;
    public static final int MAX_PARAM = 6;

    public SettingsFrame(int streamId, int flags, int payloadLength) {
        super(streamId, flags, payloadLength);
    }

    public SettingsFrame(int streamId, boolean ack) {
        super(streamId, ack ? 1 : 0, 0);
    }

    @Override
    public boolean decode(ByteBuffer buffer) {
        block8: while (buffer.remaining() >= 6 && this.remaining > 0) {
            this.remaining -= 6;
            short identifier = buffer.getShort();
            int value = buffer.getInt();
            switch (identifier) {
                case 1: {
                    this.headerTableSize = value;
                    continue block8;
                }
                case 2: {
                    this.enablePush = value;
                    continue block8;
                }
                case 3: {
                    this.maxConcurrentStreams = value;
                    continue block8;
                }
                case 4: {
                    this.initialWindowSize = value;
                    continue block8;
                }
                case 5: {
                    this.maxFrameSize = value;
                    continue block8;
                }
                case 6: {
                    this.maxHeaderListSize = value;
                    continue block8;
                }
            }
            throw new IllegalArgumentException("illegal parameter");
        }
        if (this.remaining < 0) {
            throw new IllegalStateException();
        }
        return this.remaining == 0;
    }

    @Override
    public void writeTo(WriteBuffer writeBuffer) throws IOException {
        System.out.println("write setting,streamId+" + this.streamId);
        if (this.getFlag(1)) {
            writeBuffer.writeInt(4);
            writeBuffer.writeByte((byte)1);
            writeBuffer.writeInt(this.streamId);
        } else {
            int payloadLength = 0;
            if (this.headerTableSize != -1) {
                payloadLength += 6;
            }
            if (this.enablePush != -1) {
                payloadLength += 6;
            }
            if (this.maxConcurrentStreams != -1) {
                payloadLength += 6;
            }
            if (this.initialWindowSize != -1) {
                payloadLength += 6;
            }
            if (this.maxFrameSize != -1) {
                payloadLength += 6;
            }
            if (this.maxHeaderListSize != -1) {
                payloadLength += 6;
            }
            writeBuffer.writeInt(payloadLength << 8 | 4);
            writeBuffer.writeByte((byte)0);
            writeBuffer.writeInt(this.streamId);
            if (this.headerTableSize != -1) {
                writeBuffer.writeShort((short)1);
                writeBuffer.writeInt(this.headerTableSize);
            }
            if (this.enablePush != -1) {
                writeBuffer.writeShort((short)2);
                writeBuffer.writeInt(this.enablePush);
            }
            if (this.maxConcurrentStreams != -1) {
                writeBuffer.writeShort((short)3);
                writeBuffer.writeInt(this.maxConcurrentStreams);
            }
            if (this.initialWindowSize != -1) {
                writeBuffer.writeShort((short)4);
                writeBuffer.writeInt(this.initialWindowSize);
            }
            if (this.maxFrameSize != -1) {
                writeBuffer.writeShort((short)5);
                writeBuffer.writeInt(this.maxFrameSize);
            }
            if (this.maxHeaderListSize != -1) {
                writeBuffer.writeShort((short)6);
                writeBuffer.writeInt(this.maxHeaderListSize);
            }
        }
    }

    public int getHeaderTableSize() {
        return this.headerTableSize;
    }

    public void setHeaderTableSize(int headerTableSize) {
        this.headerTableSize = headerTableSize;
    }

    public int getEnablePush() {
        return this.enablePush;
    }

    public void setEnablePush(int enablePush) {
        this.enablePush = enablePush;
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public void setMaxHeaderListSize(int maxHeaderListSize) {
        this.maxHeaderListSize = maxHeaderListSize;
    }

    @Override
    public int type() {
        return 4;
    }

    public String toString() {
        return "SettingsFrame{headerTableSize=" + this.headerTableSize + ", enablePush=" + this.enablePush + ", maxConcurrentStreams=" + this.maxConcurrentStreams + ", initialWindowSize=" + this.initialWindowSize + ", maxFrameSize=" + this.maxFrameSize + ", maxHeaderListSize=" + this.maxHeaderListSize + '}';
    }
}

