/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ParamDecodeUtils {
    private static char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static byte MASK = (byte)127;
    private static int MASK_128 = 128;
    private static byte[] HEX_DECODE = new byte[MASK_128];
    private static String BASE64_ENCODING_MARKER = "B";
    private static String QUOTEDPRINTABLE_ENCODING_MARKER = "Q";
    private static String ENCODED_TOKEN_MARKER = "=?";
    private static String ENCODED_TOKEN_FINISHER = "?=";
    private static String LINEAR_WHITESPACE = " \t\r\n";
    private static Map<String, String> MIME2JAVA = new HashMap<String, String>();

    public static String decodeRFC2231Text(String encodedText) throws UnsupportedEncodingException {
        int firstQuoteIndex = encodedText.indexOf(39);
        if (firstQuoteIndex == -1) {
            return encodedText;
        }
        int secondQuoteIndex = encodedText.indexOf(39, firstQuoteIndex + 1);
        if (secondQuoteIndex == -1) {
            return encodedText;
        }
        String charset = encodedText.substring(0, firstQuoteIndex);
        String encodedBytesPart = encodedText.substring(secondQuoteIndex + 1);
        byte[] decodedBytes = ParamDecodeUtils.fromHex(encodedBytesPart);
        return new String(decodedBytes, charset);
    }

    private static byte[] fromHex(String text) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '%' && i + 2 < text.length()) {
                int hexValue = HEX_DECODE[text.charAt(++i) & MASK] << 4 | HEX_DECODE[text.charAt(++i) & MASK];
                out.write(hexValue);
                continue;
            }
            out.write((byte)c);
        }
        return out.toByteArray();
    }

    public static String decodeRFC2047Text(String text) throws UnsupportedEncodingException {
        if (!text.contains(ENCODED_TOKEN_MARKER)) {
            return text;
        }
        int offset = 0;
        int endOffset = text.length();
        int startWhiteSpace = -1;
        int endWhiteSpace = -1;
        StringBuilder decodedText = new StringBuilder(text.length());
        boolean wasPreviousTokenEncoded = false;
        while (offset < endOffset) {
            char currentChar = text.charAt(offset);
            if (LINEAR_WHITESPACE.indexOf(currentChar) != -1) {
                startWhiteSpace = offset;
                while (offset < endOffset && LINEAR_WHITESPACE.indexOf(text.charAt(offset)) != -1) {
                    ++offset;
                }
                endWhiteSpace = offset;
                continue;
            }
            int wordStart = offset;
            while (offset < endOffset && LINEAR_WHITESPACE.indexOf(text.charAt(offset)) == -1) {
                ++offset;
            }
            String word = text.substring(wordStart, offset);
            if (word.startsWith(ENCODED_TOKEN_MARKER)) {
                try {
                    String decodedWord = ParamDecodeUtils.decodeRFC2047Word(word);
                    if (!wasPreviousTokenEncoded && startWhiteSpace != -1) {
                        decodedText.append(text, startWhiteSpace, endWhiteSpace);
                    }
                    wasPreviousTokenEncoded = true;
                    decodedText.append(decodedWord);
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (startWhiteSpace != -1) {
                decodedText.append(text, startWhiteSpace, endWhiteSpace);
            }
            wasPreviousTokenEncoded = false;
            decodedText.append(word);
        }
        return decodedText.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String decodeRFC2047Word(String word) throws ParseException, UnsupportedEncodingException {
        int startMarkerPos = word.indexOf(ENCODED_TOKEN_MARKER);
        if (startMarkerPos != 0) {
            throw new ParseException("invalid coding vocabulary: " + word, startMarkerPos);
        }
        int charsetEndPos = word.indexOf(63, 2);
        if (charsetEndPos == -1) {
            throw new ParseException("missing character sets in encoding vocabulary: " + word, charsetEndPos);
        }
        String charset = word.substring(2, charsetEndPos).toLowerCase(Locale.ROOT);
        int encodingEndPos = word.indexOf(63, charsetEndPos + 1);
        if (encodingEndPos == -1) {
            throw new ParseException("the lack of coding in the coding vocabulary: " + word, encodingEndPos);
        }
        String encoding = word.substring(charsetEndPos + 1, encodingEndPos);
        int textEndPos = word.indexOf(ENCODED_TOKEN_FINISHER, encodingEndPos + 1);
        if (textEndPos == -1) {
            throw new ParseException("coded text is missing from the coded vocabulary: " + word, textEndPos);
        }
        String encodedText = word.substring(encodingEndPos + 1, textEndPos);
        if (encodedText.isEmpty()) {
            return "";
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(encodedText.length());){
            byte[] encodedData = encodedText.getBytes(StandardCharsets.US_ASCII);
            if (BASE64_ENCODING_MARKER.equals(encoding)) {
                out.write(Base64.getMimeDecoder().decode(encodedData));
            } else {
                if (!QUOTEDPRINTABLE_ENCODING_MARKER.equals(encoding)) throw new UnsupportedEncodingException("unknown rfc2047 code: " + encoding);
                ParamDecodeUtils.decodeQuotedPrintable(encodedData, out);
            }
            String string = out.toString(ParamDecodeUtils.javaCharset(charset));
            return string;
        }
        catch (IOException e) {
            throw new UnsupportedEncodingException("invalid rfc2047 encoding");
        }
    }

    public static void decodeQuotedPrintable(byte[] data, OutputStream out) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            byte ch = data[i];
            if (ch == 95) {
                out.write(32);
                continue;
            }
            if (ch == 61) {
                if (i + 2 >= data.length) {
                    throw new IOException("Incomplete escape sequence");
                }
                byte b1 = data[++i];
                byte b2 = data[++i];
                if (b1 == 13 && b2 == 10) continue;
                out.write(ParamDecodeUtils.hexToBinary(b1) << 4 | ParamDecodeUtils.hexToBinary(b2));
                continue;
            }
            out.write(ch);
        }
    }

    private static int hexToBinary(int b) throws IOException {
        int value = Character.digit(b, 16);
        if (value == -1) {
            throw new IOException("Invalid quoted printable encoding: not a valid hex digit: " + b);
        }
        return value;
    }

    public static boolean hasEncodedValue(String paramName) {
        if (paramName != null) {
            return paramName.lastIndexOf(42) == paramName.length() - 1;
        }
        return false;
    }

    public static String stripDelimiter(String paramName) {
        if (ParamDecodeUtils.hasEncodedValue(paramName)) {
            StringBuilder paramBuilder = new StringBuilder(paramName);
            paramBuilder.deleteCharAt(paramName.lastIndexOf(42));
            return paramBuilder.toString();
        }
        return paramName;
    }

    private static String javaCharset(String charset) {
        if (charset == null) {
            return null;
        }
        String mappedCharset = MIME2JAVA.get(charset.toLowerCase(Locale.ROOT));
        return mappedCharset == null ? charset : mappedCharset;
    }

    static {
        MIME2JAVA.put("iso-2022-cn", "ISO2022CN");
        MIME2JAVA.put("iso-2022-kr", "ISO2022KR");
        MIME2JAVA.put("utf-8", "UTF8");
        MIME2JAVA.put("utf8", "UTF8");
        MIME2JAVA.put("ja_jp.iso2022-7", "ISO2022JP");
        MIME2JAVA.put("ja_jp.eucjp", "EUCJIS");
        MIME2JAVA.put("euc-kr", "KSC5601");
        MIME2JAVA.put("euckr", "KSC5601");
        MIME2JAVA.put("us-ascii", StandardCharsets.ISO_8859_1.name());
        MIME2JAVA.put("x-us-ascii", StandardCharsets.ISO_8859_1.name());
        for (int i = 0; i < HEX_DIGITS.length; ++i) {
            ParamDecodeUtils.HEX_DECODE[ParamDecodeUtils.HEX_DIGITS[i]] = (byte)i;
            ParamDecodeUtils.HEX_DECODE[Character.toLowerCase((char)ParamDecodeUtils.HEX_DIGITS[i])] = (byte)i;
            ParamDecodeUtils.HEX_DECODE[Character.toLowerCase((char)ParamDecodeUtils.HEX_DIGITS[i])] = (byte)i;
        }
    }
}

