/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.waf;

import java.nio.ByteBuffer;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.waf.AbstractWafDecoder;
import org.smartboot.http.server.waf.WafConfiguration;
import org.smartboot.http.server.waf.WafException;

public class MethodWafDecoder
extends AbstractWafDecoder {
    public MethodWafDecoder(HttpServerConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected Decoder decode0(ByteBuffer byteBuffer, Request request) {
        WafConfiguration wafConfiguration = this.getConfiguration().getWafConfiguration();
        if (!wafConfiguration.getAllowMethods().isEmpty() && !wafConfiguration.getAllowMethods().contains(request.getMethod())) {
            throw new WafException(HttpStatus.METHOD_NOT_ALLOWED, "Mysterious Power from the East Is Protecting This Area.");
        }
        if (!wafConfiguration.getDenyMethods().isEmpty() && wafConfiguration.getDenyMethods().contains(request.getMethod())) {
            throw new WafException(HttpStatus.METHOD_NOT_ALLOWED, "Mysterious Power from the East Is Protecting This Area.");
        }
        return null;
    }
}

