/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Consumer;
import org.noear.socketd.exception.SocketdChannelException;
import org.noear.socketd.exception.SocketdException;
import org.noear.socketd.transport.client.ClientConnector;
import org.noear.socketd.transport.core.Acceptor;
import org.noear.socketd.transport.core.Asserts;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.ChannelBase;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.HeartbeatHandler;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.internal.HeartbeatHandlerDefault;
import org.noear.socketd.utils.RunUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientChannel
extends ChannelBase
implements Channel {
    private static final Logger log = LoggerFactory.getLogger(ClientChannel.class);
    private ClientConnector connector;
    private Channel real;
    private HeartbeatHandler heartbeatHandler;
    private ScheduledFuture<?> heartbeatScheduledFuture;

    public ClientChannel(Channel real, ClientConnector connector) {
        super(real.getConfig());
        this.real = real;
        this.connector = connector;
        this.heartbeatHandler = connector.heartbeatHandler();
        if (this.heartbeatHandler == null) {
            this.heartbeatHandler = new HeartbeatHandlerDefault();
        }
        this.initHeartbeat();
    }

    private void initHeartbeat() {
        if (this.connector.autoReconnect() && (this.heartbeatScheduledFuture == null || this.heartbeatScheduledFuture.isCancelled())) {
            this.heartbeatScheduledFuture = RunUtils.delayAndRepeat(() -> {
                block2: {
                    try {
                        this.heartbeatHandle();
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block2;
                        log.debug("{}", (Throwable)e);
                    }
                }
            }, this.connector.heartbeatInterval());
        }
    }

    @Override
    public void removeAcceptor(String sid) {
        if (this.real != null) {
            this.real.removeAcceptor(sid);
        }
    }

    @Override
    public boolean isValid() {
        if (this.real == null) {
            return false;
        }
        return this.real.isValid();
    }

    @Override
    public boolean isClosed() {
        if (this.real == null) {
            return false;
        }
        return this.real.isClosed();
    }

    @Override
    public InetSocketAddress getRemoteAddress() throws IOException {
        if (this.real == null) {
            return null;
        }
        return this.real.getRemoteAddress();
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        if (this.real == null) {
            return null;
        }
        return this.real.getLocalAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void heartbeatHandle() throws IOException {
        if (this.real != null) {
            if (this.real.getHandshake() == null) {
                return;
            }
            if (this.real.isClosed()) {
                if (log.isDebugEnabled()) {
                    log.debug("The channel is closed, sessionId={}", (Object)this.getSession().sessionId());
                }
                return;
            }
        }
        ClientChannel clientChannel = this;
        synchronized (clientChannel) {
            try {
                this.prepareCheck();
                this.heartbeatHandler.heartbeat(this.getSession());
            }
            catch (SocketdException e) {
                throw e;
            }
            catch (Throwable e) {
                if (this.connector.autoReconnect()) {
                    this.real.close();
                    this.real = null;
                }
                throw new SocketdChannelException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Frame frame, Acceptor acceptor) throws IOException {
        Asserts.assertClosed(this.real);
        ClientChannel clientChannel = this;
        synchronized (clientChannel) {
            try {
                this.prepareCheck();
                this.real.send(frame, acceptor);
            }
            catch (SocketdException e) {
                throw e;
            }
            catch (Throwable e) {
                if (this.connector.autoReconnect()) {
                    this.real.close();
                    this.real = null;
                }
                throw new SocketdChannelException(e);
            }
        }
    }

    @Override
    public void retrieve(Frame frame, Consumer<Throwable> onError) {
        this.real.retrieve(frame, onError);
    }

    @Override
    public Session getSession() {
        return this.real.getSession();
    }

    @Override
    public void reconnect() throws Exception {
        this.initHeartbeat();
        this.prepareCheck();
    }

    @Override
    public void close() throws IOException {
        RunUtils.runAnTry(() -> this.heartbeatScheduledFuture.cancel(true));
        RunUtils.runAnTry(() -> this.connector.close());
        RunUtils.runAnTry(() -> this.real.close());
    }

    private boolean prepareCheck() throws Exception {
        if (this.real == null || !this.real.isValid()) {
            this.real = this.connector.connect();
            return true;
        }
        return false;
    }
}

