/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.client;

import java.net.URI;
import org.noear.socketd.transport.core.ConfigBase;

public class ClientConfig
extends ConfigBase<ClientConfig> {
    private final String schema;
    private final String url;
    private final URI uri;
    private int port;
    private long heartbeatInterval;
    private long connectTimeout;
    private boolean autoReconnect;

    public ClientConfig(String url) {
        super(true);
        if (url.startsWith("sd:")) {
            url = url.substring(3);
        }
        this.url = url;
        this.uri = URI.create(url);
        this.port = this.uri.getPort();
        this.schema = this.uri.getScheme();
        if (this.port < 0) {
            this.port = 8602;
        }
        this.connectTimeout = 10000L;
        this.heartbeatInterval = 20000L;
        this.autoReconnect = true;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getUrl() {
        return this.url;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public int getPort() {
        return this.port;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public ClientConfig heartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
        return this;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public ClientConfig connectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public ClientConfig autoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    @Override
    public ClientConfig idleTimeout(int idleTimeout) {
        if (!this.autoReconnect) {
            return (ClientConfig)super.idleTimeout(idleTimeout);
        }
        return (ClientConfig)super.idleTimeout(0);
    }

    public String toString() {
        return "ClientConfig{schema='" + this.schema + '\'' + ", charset=" + this.charset + ", url='" + this.url + '\'' + ", heartbeatInterval=" + this.heartbeatInterval + ", connectTimeout=" + this.connectTimeout + ", idleTimeout=" + this.idleTimeout + ", requestTimeout=" + this.requestTimeout + ", readBufferSize=" + this.readBufferSize + ", writeBufferSize=" + this.writeBufferSize + ", autoReconnect=" + this.autoReconnect + ", maxRequests=" + this.maxRequests + ", maxUdpSize=" + this.maxUdpSize + '}';
    }
}

