/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.internal.Frames;
import org.noear.socketd.transport.core.internal.HandshakeInternal;

public abstract class ChannelBase
implements Channel {
    private final Config config;
    private final AtomicInteger requests = new AtomicInteger();
    private final Map<String, Object> attachments = new ConcurrentHashMap<String, Object>();
    private HandshakeInternal handshake;
    private long liveTime;
    private boolean isClosed;

    @Override
    public Config getConfig() {
        return this.config;
    }

    public ChannelBase(Config config) {
        this.config = config;
    }

    @Override
    public <T> T getAttachment(String name) {
        return (T)this.attachments.get(name);
    }

    @Override
    public void setAttachment(String name, Object val) {
        this.attachments.put(name, val);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public AtomicInteger getRequests() {
        return this.requests;
    }

    @Override
    public void setHandshake(HandshakeInternal handshake) {
        this.handshake = handshake;
    }

    @Override
    public HandshakeInternal getHandshake() {
        return this.handshake;
    }

    @Override
    public void sendConnect(String uri) throws IOException {
        this.send(Frames.connectFrame(this.getConfig().getIdGenerator().generate(), uri), null);
    }

    @Override
    public void sendConnack(Message connectMessage) throws IOException {
        this.send(Frames.connackFrame(connectMessage), null);
    }

    @Override
    public void sendPing() throws IOException {
        this.send(Frames.pingFrame(), null);
    }

    @Override
    public void sendPong() throws IOException {
        this.send(Frames.pongFrame(), null);
    }

    @Override
    public void sendClose() throws IOException {
        this.send(Frames.closeFrame(), null);
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.attachments.clear();
    }
}

