/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.noear.socketd.exception.SocketdSizeLimitException;
import org.noear.socketd.transport.core.Codec;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Flag;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.buffer.BufferReader;
import org.noear.socketd.transport.core.buffer.BufferWriter;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.internal.MessageDefault;
import org.noear.socketd.utils.IoUtils;

public class CodecByteBuffer
implements Codec<BufferReader, BufferWriter> {
    private final Config config;

    public CodecByteBuffer(Config config) {
        this.config = config;
    }

    @Override
    public <T extends BufferWriter> T write(Frame frame, Function<Integer, T> factory) throws IOException {
        if (frame.getMessage() == null) {
            int frameSize = 8;
            BufferWriter target = (BufferWriter)factory.apply(frameSize);
            target.putInt(frameSize);
            target.putInt(frame.getFlag().getCode());
            target.flush();
            return (T)target;
        }
        byte[] sidB = frame.getMessage().sid().getBytes(this.config.getCharset());
        byte[] topicB = frame.getMessage().topic().getBytes(this.config.getCharset());
        byte[] metaStringB = frame.getMessage().metaString().getBytes(this.config.getCharset());
        int frameSize = 8 + sidB.length + topicB.length + metaStringB.length + frame.getMessage().dataSize() + 6;
        this.assertSize("sid", sidB.length, 64);
        this.assertSize("topic", topicB.length, 512);
        this.assertSize("metaString", metaStringB.length, 4096);
        this.assertSize("data", frame.getMessage().dataSize(), 0x1000000);
        BufferWriter target = (BufferWriter)factory.apply(frameSize);
        target.putInt(frameSize);
        target.putInt(frame.getFlag().getCode());
        target.putBytes(sidB);
        target.putChar(10);
        target.putBytes(topicB);
        target.putChar(10);
        target.putBytes(metaStringB);
        target.putChar(10);
        IoUtils.writeTo(frame.getMessage().data(), target);
        target.flush();
        return (T)target;
    }

    @Override
    public Frame read(BufferReader buffer) {
        byte[] data;
        int frameSize = buffer.getInt();
        if (frameSize > buffer.remaining() + 4) {
            return null;
        }
        int flag = buffer.getInt();
        if (frameSize == 8) {
            return new Frame(Flag.Of(flag), null);
        }
        int metaBufSize = Math.min(4096, buffer.remaining());
        ByteBuffer sb = ByteBuffer.allocate(metaBufSize);
        String sid = this.decodeString(buffer, sb, 64);
        String topic = this.decodeString(buffer, sb, 512);
        String metaString = this.decodeString(buffer, sb, 4096);
        int dataRealSize = frameSize - buffer.position();
        if (dataRealSize > 0x1000000) {
            data = new byte[0x1000000];
            buffer.get(data, 0, 0x1000000);
            for (int i = dataRealSize - 0x1000000; i > 0; --i) {
                buffer.get();
            }
        } else {
            data = new byte[dataRealSize];
            if (dataRealSize > 0) {
                buffer.get(data, 0, dataRealSize);
            }
        }
        MessageDefault message = new MessageDefault().sid(sid).topic(topic).entity(new EntityDefault().metaString(metaString).data(data));
        message.flag(Flag.Of(flag));
        return new Frame(message.getFlag(), message);
    }

    protected String decodeString(BufferReader reader, ByteBuffer buf, int maxLen) {
        byte c;
        buf.clear();
        while ((c = reader.get()) != 10) {
            if (maxLen > 0 && maxLen <= buf.position() || c == 0) continue;
            buf.put(c);
        }
        buf.flip();
        if (buf.limit() < 1) {
            return "";
        }
        return new String(buf.array(), 0, buf.limit(), this.config.getCharset());
    }

    private void assertSize(String name, int size, int limitSize) {
        if (size > limitSize) {
            StringBuilder buf = new StringBuilder();
            buf.append("This message ").append(name).append(" size is out of limit ").append(limitSize).append(" (").append(size).append(")");
            throw new SocketdSizeLimitException(buf.toString());
        }
    }
}

