/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.internal;

import java.io.IOException;
import org.noear.socketd.exception.SocketdConnectionException;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.Flag;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Processor;
import org.noear.socketd.transport.core.internal.HandshakeInternal;
import org.noear.socketd.transport.core.listener.SimpleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorDefault
implements Processor {
    private static Logger log = LoggerFactory.getLogger(ProcessorDefault.class);
    private Listener listener = new SimpleListener();

    @Override
    public void setListener(Listener listener) {
        if (listener != null) {
            this.listener = listener;
        }
    }

    @Override
    public void onReceive(Channel channel, Frame frame) throws IOException {
        if (log.isDebugEnabled()) {
            if (channel.getConfig().clientMode()) {
                log.debug("C-REV:{}", (Object)frame);
            } else {
                log.debug("S-REV:{}", (Object)frame);
            }
        }
        if (frame.getFlag() == Flag.Connect) {
            HandshakeInternal handshake = new HandshakeInternal(frame.getMessage());
            channel.setHandshake(handshake);
            this.onOpen(channel);
            if (channel.isValid()) {
                channel.sendConnack(frame.getMessage());
            }
        } else if (frame.getFlag() == Flag.Connack) {
            HandshakeInternal handshake = new HandshakeInternal(frame.getMessage());
            channel.setHandshake(handshake);
            this.onOpen(channel);
        } else {
            if (channel.getHandshake() == null) {
                channel.close();
                if (frame.getFlag() == Flag.Close) {
                    throw new SocketdConnectionException("Connection request was rejected");
                }
                if (log.isWarnEnabled()) {
                    log.warn("Channel andshake is null, sessionId={}", (Object)channel.getSession().sessionId());
                }
                return;
            }
            try {
                switch (frame.getFlag()) {
                    case Ping: {
                        channel.sendPong();
                        break;
                    }
                    case Pong: {
                        break;
                    }
                    case Close: {
                        channel.close();
                        this.onCloseInternal(channel);
                        break;
                    }
                    case Message: 
                    case Request: 
                    case Subscribe: {
                        this.onReceiveDo(channel, frame, false);
                        break;
                    }
                    case Reply: 
                    case ReplyEnd: {
                        this.onReceiveDo(channel, frame, true);
                        break;
                    }
                    default: {
                        channel.close();
                        this.onClose(channel);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                this.onError(channel, e);
            }
        }
    }

    private void onReceiveDo(Channel channel, Frame frame, boolean isReply) throws IOException {
        String fragmentIdxStr = frame.getMessage().meta("Data-Fragment-Idx");
        if (fragmentIdxStr != null) {
            int index = Integer.parseInt(fragmentIdxStr);
            Frame frameNew = channel.getConfig().getFragmentHandler().aggrFragment(channel, index, frame);
            if (frameNew == null) {
                return;
            }
            frame = frameNew;
        }
        if (isReply) {
            channel.retrieve(frame, error -> this.onError(channel, (Throwable)error));
        } else {
            this.onMessage(channel, frame.getMessage());
        }
    }

    @Override
    public void onOpen(Channel channel) throws IOException {
        this.listener.onOpen(channel.getSession());
    }

    @Override
    public void onMessage(Channel channel, Message message) throws IOException {
        channel.getConfig().getChannelExecutor().submit(() -> {
            block2: {
                try {
                    this.listener.onMessage(channel.getSession(), message);
                }
                catch (Throwable e) {
                    if (!log.isWarnEnabled()) break block2;
                    log.warn("{}", e);
                }
            }
        });
    }

    @Override
    public void onClose(Channel channel) {
        if (!channel.isClosed()) {
            this.onCloseInternal(channel);
        }
    }

    private void onCloseInternal(Channel channel) {
        this.listener.onClose(channel.getSession());
    }

    @Override
    public void onError(Channel channel, Throwable error) {
        this.listener.onError(channel.getSession(), error);
    }
}

