/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.noear.socketd.transport.core.buffer.BufferWriter;
import org.noear.socketd.utils.Utils;

public class IoUtils {
    public static String transferToString(InputStream ins) throws IOException {
        return IoUtils.transferToString(ins, "UTF-8");
    }

    public static String transferToString(InputStream ins, String charset) throws IOException {
        if (ins == null) {
            return null;
        }
        ByteArrayOutputStream outs = IoUtils.transferTo(ins, new ByteArrayOutputStream());
        if (Utils.isEmpty(charset)) {
            return outs.toString();
        }
        return outs.toString(charset);
    }

    public static byte[] transferToBytes(InputStream ins) throws IOException {
        if (ins == null) {
            return null;
        }
        return IoUtils.transferTo(ins, new ByteArrayOutputStream()).toByteArray();
    }

    public static <T extends OutputStream> T transferTo(InputStream ins, T out) throws IOException {
        if (ins == null || out == null) {
            return null;
        }
        int len = 0;
        byte[] buf = new byte[512];
        while ((len = ins.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        return out;
    }

    public static <T extends OutputStream> T transferTo(InputStream ins, T out, long start, long length) throws IOException {
        int len = 0;
        byte[] buf = new byte[512];
        int bufMax = buf.length;
        if (length < (long)bufMax) {
            bufMax = (int)length;
        }
        if (start > 0L) {
            ins.skip(start);
        }
        while ((len = ins.read(buf, 0, bufMax)) != -1) {
            out.write(buf, 0, len);
            if ((long)bufMax <= (length -= (long)len) || (bufMax = (int)length) != 0) continue;
            break;
        }
        return out;
    }

    public static void writeTo(InputStream ins, BufferWriter out) throws IOException {
        if (ins == null || out == null) {
            return;
        }
        int len = 0;
        byte[] buf = new byte[512];
        while ((len = ins.read(buf)) != -1) {
            out.putBytes(buf, 0, len);
        }
    }
}

