/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.dashscope;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.generate.GenerateConfig;
import org.noear.solon.ai.generate.GenerateContent;
import org.noear.solon.ai.generate.GenerateException;
import org.noear.solon.ai.generate.GenerateOptions;
import org.noear.solon.ai.generate.GenerateResponse;
import org.noear.solon.ai.generate.dialect.AbstractGenerateDialect;

public class DashscopeGenerateDialect
extends AbstractGenerateDialect {
    private static final String URL_PREFIX = "https://dashscope.aliyuncs.com/api/v1/services/";
    private static DashscopeGenerateDialect instance = new DashscopeGenerateDialect();

    public static DashscopeGenerateDialect getInstance() {
        return instance;
    }

    public boolean matched(GenerateConfig config) {
        if ("dashscope".equals(config.getProvider())) {
            return true;
        }
        return config.getApiUrl().startsWith(URL_PREFIX);
    }

    public String buildRequestJson(GenerateConfig config, GenerateOptions options, String promptStr, Map promptMap) {
        return new ONode().build(n -> {
            if (Utils.isNotEmpty((String)config.getModel())) {
                n.set("model", (Object)config.getModel());
            }
            if (Utils.isNotEmpty((String)promptStr)) {
                n.getOrNew("input").set("prompt", (Object)promptStr);
            } else if (Utils.isNotEmpty((Map)promptMap)) {
                n.set("input", (Object)ONode.load((Object)promptMap));
            }
            n.getOrNew("parameters").build(n1 -> {
                for (Map.Entry kv : options.options().entrySet()) {
                    n1.set((String)kv.getKey(), kv.getValue());
                }
            });
        }).toJson();
    }

    public GenerateResponse parseResponseJson(GenerateConfig config, String respJson) {
        ONode oResp = ONode.load((Object)respJson);
        String model = oResp.get("model").getString();
        if (oResp.contains("code") && !Utils.isEmpty((String)oResp.get("code").getString())) {
            return new GenerateResponse(model, new GenerateException(oResp.get("code").getString() + ": " + oResp.get("message").getString()), null, null);
        }
        List<GenerateContent> data = null;
        ONode oOutput = oResp.get("output");
        if (oOutput.contains("task_id")) {
            String url = config.getTaskUrlAndId(oOutput.get("task_id").getString());
            data = Arrays.asList(GenerateContent.builder().url(url).build());
        } else if (oOutput.contains("results")) {
            data = oOutput.get("results").toObjectList(GenerateContent.class);
        }
        return new GenerateResponse(model, null, (List)data, null);
    }
}

