/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.ollama;

import java.util.Arrays;
import java.util.List;
import org.noear.snack.ONode;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.generate.GenerateConfig;
import org.noear.solon.ai.generate.GenerateContent;
import org.noear.solon.ai.generate.GenerateException;
import org.noear.solon.ai.generate.GenerateResponse;
import org.noear.solon.ai.generate.dialect.AbstractGenerateDialect;

public class OllamaGenerateDialect
extends AbstractGenerateDialect {
    private static OllamaGenerateDialect instance = new OllamaGenerateDialect();

    public static OllamaGenerateDialect getInstance() {
        return instance;
    }

    public boolean matched(GenerateConfig config) {
        return "ollama".equals(config.getProvider());
    }

    public GenerateResponse parseResponseJson(GenerateConfig config, String respJson) {
        ONode oResp = ONode.load((Object)respJson);
        String model = oResp.get("model").getString();
        if (oResp.contains("error")) {
            return new GenerateResponse(model, new GenerateException(oResp.get("error").getString()), null, null);
        }
        List<GenerateContent> data = null;
        if (oResp.contains("response")) {
            String text = oResp.get("response").getString();
            data = Arrays.asList(GenerateContent.builder().text(text).build());
        } else if (oResp.contains("data")) {
            data = oResp.get("data").toObjectList(GenerateContent.class);
        }
        AiUsage usage = null;
        if (oResp.contains("prompt_eval_count")) {
            int prompt_eval_count = oResp.get("prompt_eval_count").getInt();
            usage = new AiUsage((long)prompt_eval_count, 0L, (long)prompt_eval_count);
        }
        return new GenerateResponse(model, null, data, usage);
    }
}

