/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.openai;

import java.util.Date;
import java.util.List;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.chat.ChatChoice;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.ChatException;
import org.noear.solon.ai.chat.ChatResponseDefault;
import org.noear.solon.ai.chat.dialect.AbstractChatDialect;
import org.noear.solon.ai.chat.message.AssistantMessage;

public class OpenaiChatDialect
extends AbstractChatDialect {
    private static final OpenaiChatDialect instance = new OpenaiChatDialect();

    public static OpenaiChatDialect getInstance() {
        return instance;
    }

    public boolean isDefault() {
        return true;
    }

    public boolean matched(ChatConfig config) {
        return false;
    }

    public boolean parseResponseJson(ChatConfig config, ChatResponseDefault resp, String json) {
        if ("[DONE]".equals(json)) {
            if (!resp.isFinished()) {
                resp.addChoice(new ChatChoice(0, new Date(), "stop", new AssistantMessage("")));
                resp.setFinished(true);
            }
            return true;
        }
        ONode oResp = ONode.load((Object)json);
        if (!oResp.isObject()) {
            return false;
        }
        if ("error".equals(oResp.get("object").getString())) {
            resp.setError(new ChatException(oResp.get("message").getString()));
        } else if (oResp.contains("error")) {
            resp.setError(new ChatException(oResp.get("error").getString()));
        } else {
            ONode oUsage;
            resp.setModel(oResp.get("model").getString());
            Date created = new Date(oResp.get("created").getLong() * 1000L);
            for (ONode oChoice1 : oResp.get("choices").ary()) {
                int index = oChoice1.get("index").getInt();
                String finish_reason = oChoice1.get("finish_reason").getString();
                List messageList = resp.isStream() ? this.parseAssistantMessage(resp, oChoice1.get("delta")) : this.parseAssistantMessage(resp, oChoice1.get("message"));
                for (AssistantMessage msg1 : messageList) {
                    resp.addChoice(new ChatChoice(index, created, finish_reason, msg1));
                }
                if (!Utils.isNotEmpty((String)finish_reason)) continue;
                resp.setFinished(true);
            }
            if (resp.isFinished() && !resp.hasChoices()) {
                resp.addChoice(new ChatChoice(0, created, "stop", new AssistantMessage("")));
            }
            if ((oUsage = oResp.getOrNull("usage")) != null) {
                long promptTokens = oUsage.get("prompt_tokens").getLong();
                long completionTokens = oUsage.get("completion_tokens").getLong();
                long totalTokens = oUsage.get("total_tokens").getLong();
                resp.setUsage(new AiUsage(promptTokens, completionTokens, totalTokens));
            }
        }
        return true;
    }
}

