/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.spec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import io.modelcontextprotocol.spec.JsonSchemaValidator;
import io.modelcontextprotocol.util.Assert;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJsonSchemaValidator
implements JsonSchemaValidator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJsonSchemaValidator.class);
    private final ObjectMapper objectMapper;
    private final JsonSchemaFactory schemaFactory;
    private final ConcurrentHashMap<String, JsonSchema> schemaCache;

    public DefaultJsonSchemaValidator() {
        this(new ObjectMapper());
    }

    public DefaultJsonSchemaValidator(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.schemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012);
        this.schemaCache = new ConcurrentHashMap();
    }

    @Override
    public JsonSchemaValidator.ValidationResponse validate(Map<String, Object> schema, Map<String, Object> structuredContent) {
        Assert.notNull(schema, "Schema must not be null");
        Assert.notNull(structuredContent, "Structured content must not be null");
        try {
            JsonNode jsonStructuredOutput = this.objectMapper.valueToTree(structuredContent);
            Set validationResult = this.getOrCreateJsonSchema(schema).validate(jsonStructuredOutput);
            if (!validationResult.isEmpty()) {
                return JsonSchemaValidator.ValidationResponse.asInvalid("Validation failed: structuredContent does not match tool outputSchema. Validation errors: " + validationResult);
            }
            return JsonSchemaValidator.ValidationResponse.asValid(jsonStructuredOutput.toString());
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to validate CallToolResult: Error parsing schema: {}", (Throwable)e);
            return JsonSchemaValidator.ValidationResponse.asInvalid("Error parsing tool JSON Schema: " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("Failed to validate CallToolResult: Unexpected error: {}", (Throwable)e);
            return JsonSchemaValidator.ValidationResponse.asInvalid("Unexpected validation error: " + e.getMessage());
        }
    }

    private JsonSchema getOrCreateJsonSchema(Map<String, Object> schema) throws JsonProcessingException {
        String cacheKey = this.generateCacheKey(schema);
        JsonSchema cachedSchema = this.schemaCache.get(cacheKey);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        JsonSchema newSchema = this.createJsonSchema(schema);
        JsonSchema existingSchema = this.schemaCache.putIfAbsent(cacheKey, newSchema);
        return existingSchema != null ? existingSchema : newSchema;
    }

    private JsonSchema createJsonSchema(Map<String, Object> schema) throws JsonProcessingException {
        ObjectNode objectSchemaNode;
        JsonNode schemaNode = this.objectMapper.valueToTree(schema);
        if (schemaNode == null) {
            throw new JsonProcessingException("Failed to convert schema to JsonNode"){};
        }
        if (schemaNode.isObject() && !(objectSchemaNode = (ObjectNode)schemaNode).has("additionalProperties")) {
            objectSchemaNode = objectSchemaNode.deepCopy();
            objectSchemaNode.put("additionalProperties", false);
            schemaNode = objectSchemaNode;
        }
        return this.schemaFactory.getSchema(schemaNode);
    }

    protected String generateCacheKey(Map<String, Object> schema) {
        if (schema.containsKey("$id")) {
            return "" + schema.get("$id");
        }
        return String.valueOf(schema.hashCode());
    }

    public void clearCache() {
        this.schemaCache.clear();
    }

    public int getCacheSize() {
        return this.schemaCache.size();
    }
}

