/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.async;

import java.util.concurrent.Future;
import org.noear.solon.Utils;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.aspect.MethodInterceptor;
import org.noear.solon.lang.Nullable;
import org.noear.solon.scheduling.annotation.Async;
import org.noear.solon.scheduling.async.AsyncExecutor;
import org.noear.solon.scheduling.async.AsyncExecutorDefault;

public class AsyncInterceptor
implements MethodInterceptor {
    private final AsyncExecutor asyncExecutorDef = new AsyncExecutorDefault();
    @Nullable
    private AsyncExecutor asyncExecutor;

    public void setAsyncExecutor(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    public Object doIntercept(Invocation inv) throws Throwable {
        Async anno = (Async)inv.getMethodAnnotation(Async.class);
        if (anno != null) {
            AsyncExecutor executor = null;
            if (Utils.isNotEmpty((String)anno.value())) {
                executor = (AsyncExecutor)inv.context().getBean(anno.value());
            }
            if (executor == null) {
                executor = this.asyncExecutor == null ? this.asyncExecutorDef : this.asyncExecutor;
            }
            Future future = executor.submit(inv, anno);
            if (inv.method().getReturnType().isAssignableFrom(Future.class)) {
                return future;
            }
            return null;
        }
        return inv.invoke();
    }
}

