/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.PropsLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendLoader {
    static final Logger log = LoggerFactory.getLogger(ExtendLoader.class);
    private static final ExtendLoader instance = new ExtendLoader();
    private static File folder;
    private static String folderPath;

    public static File folder() {
        return folder;
    }

    public static String path() {
        return folderPath;
    }

    public static List<ClassLoader> load(String extend) {
        return ExtendLoader.load(extend, false);
    }

    public static List<ClassLoader> load(String extend, boolean autoMake) {
        return ExtendLoader.load(extend, autoMake, null);
    }

    public static List<ClassLoader> load(String extend, boolean autoMake, Predicate<String> filter) {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        loaders.add(AppClassLoader.global());
        if (Utils.isNotEmpty(extend)) {
            if (extend.startsWith("!")) {
                extend = extend.substring(1);
                autoMake = true;
            }
            if ((folder = Utils.getFolderAndMake(extend, autoMake)) != null) {
                folderPath = folder.toURI().getPath();
                log.info("Extend root: " + folderPath);
                instance.loadFile(loaders, folder, filter);
            }
        }
        return loaders;
    }

    public static boolean loadJar(List<ClassLoader> loaders, File file) {
        try {
            if (file.getName().startsWith("!")) {
                loaders.add(AppClassLoader.loadJar(file));
            } else {
                AppClassLoader.global().addJar(file);
            }
            return true;
        }
        catch (Throwable e) {
            log.warn("ExtendLoader loadJar failed!", e);
            return false;
        }
    }

    public static boolean loadJar(File file) {
        try {
            AppClassLoader.global().addJar(file);
            return true;
        }
        catch (Throwable e) {
            log.warn("ExtendLoader loadJar failed!", e);
            return false;
        }
    }

    public static boolean unloadJar(File file) {
        try {
            AppClassLoader.global().removeJar(file);
            return true;
        }
        catch (Throwable e) {
            log.warn("ExtendLoader unloadJar failed!", e);
            return false;
        }
    }

    private ExtendLoader() {
    }

    private void loadFile(List<ClassLoader> loaders, File file, Predicate<String> filter) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] tmps;
            for (File tmp : tmps = file.listFiles()) {
                this.loadFileDo(loaders, tmp, filter);
            }
        } else {
            this.loadFileDo(loaders, file, filter);
        }
    }

    private void loadFileDo(List<ClassLoader> loaders, File file, Predicate<String> filter) {
        if (file.isFile()) {
            String path = file.getAbsolutePath();
            if (filter != null && !filter.test(path)) {
                return;
            }
            try {
                if (path.endsWith(".jar") || path.endsWith(".zip")) {
                    ExtendLoader.loadJar(loaders, file);
                    return;
                }
                if (path.endsWith(".properties")) {
                    Solon.cfg().loadAdd(file.toURI().toURL());
                    log.info("loaded: " + path);
                    return;
                }
                if (path.endsWith(".yml")) {
                    if (!PropsLoader.global().isSupport(path)) {
                        throw new IllegalStateException("Do not support the *.yml");
                    }
                    Solon.cfg().loadAdd(file.toURI().toURL());
                    log.info("loaded: " + path);
                    return;
                }
            }
            catch (Throwable e) {
                log.warn("ExtendLoader loadFile failed!", e);
            }
        }
    }
}

