/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.socket.transport.AioSession;

public class ChunkedInputStream
extends InputStream {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(8);
    private boolean readFlag = true;
    private final AioSession session;
    private InputStream inputStream;
    private boolean eof = false;
    private int remainingThreshold;

    public ChunkedInputStream(AioSession session, int maxPayload) {
        this.session = session;
        this.remainingThreshold = maxPayload;
    }

    @Override
    public int read() {
        throw new UnsupportedOperationException("unsafe operation");
    }

    @Override
    public int read(byte[] data, int off, int len) throws IOException {
        this.readChunkedLength();
        if (this.eof) {
            return -1;
        }
        int i = this.inputStream.read(data, off, len);
        if (i == -1) {
            this.inputStream.close();
            this.inputStream = this.session.getInputStream();
            this.readCrlf();
            this.readFlag = true;
            return this.read(data, off, len);
        }
        return i;
    }

    private void readChunkedLength() throws IOException {
        while (this.readFlag) {
            this.inputStream = this.session.getInputStream();
            int b = this.inputStream.read();
            if (b == -1) {
                throw new IOException("inputStream is closed");
            }
            if (b == 10) {
                int length = Integer.parseInt(this.buffer.toString(), 16);
                this.remainingThreshold = this.remainingThreshold - 2 - this.buffer.size() - length;
                if (this.remainingThreshold < 0) {
                    throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
                }
                this.buffer.reset();
                if (length == 0) {
                    this.eof = true;
                    this.readCrlf();
                    break;
                }
                this.inputStream.close();
                this.inputStream = this.session.getInputStream(length);
                this.readFlag = false;
                continue;
            }
            if (b == 13) continue;
            this.buffer.write(b);
        }
    }

    private void readCrlf() throws IOException {
        if (this.inputStream.read() != 13) {
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
        if (this.inputStream.read() != 10) {
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }
}

