/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.logging;

import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.smartboot.http.common.logging.LogFormatter;
import org.smartboot.http.common.logging.Logger;

class RunLogger
implements Logger {
    private final String loggerName;
    private java.util.logging.Logger logger = null;

    RunLogger(String name) {
        this.loggerName = name;
        this.logger = java.util.logging.Logger.getLogger(name);
        this.init();
    }

    private void init() {
        this.logger.setUseParentHandlers(false);
        try {
            Handler[] handlers = this.logger.getHandlers();
            if (handlers != null) {
                for (Handler h : handlers) {
                    this.logger.removeHandler(h);
                }
            }
            this.logger.setLevel(Level.ALL);
            ConsoleHandler ch = new ConsoleHandler();
            ch.setFormatter(new LogFormatter());
            ch.setLevel(Level.ALL);
            try {
                ch.setEncoding("utf8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.logger.addHandler(ch);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void log(Level level, String msg, Object ... arguments) {
        LogRecord record = new LogRecord(level, null);
        record.setMessage(msg);
        if (arguments != null && arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable) {
            record.setThrown((Throwable)arguments[arguments.length - 1]);
        }
        this.logger.log(record);
    }

    @Override
    public String getName() {
        return this.loggerName;
    }

    @Override
    public boolean isTraceEnabled() {
        return false;
    }

    @Override
    public void trace(String msg) {
        this.log(Level.FINE, msg, new Object[0]);
    }

    @Override
    public void trace(String format, Object arg) {
        this.log(Level.FINE, format, arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.log(Level.FINE, format, arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.log(Level.FINE, format, arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.log(Level.FINE, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public void debug(String msg) {
        this.log(Level.CONFIG, msg, new Object[0]);
    }

    @Override
    public void debug(String format, Object arg) {
        this.log(Level.CONFIG, format, arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.log(Level.CONFIG, format, arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.log(Level.CONFIG, format, arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log(Level.CONFIG, msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return false;
    }

    @Override
    public void info(String msg) {
        this.log(Level.INFO, msg, new Object[0]);
    }

    @Override
    public void info(String format, Object arg) {
        this.log(Level.INFO, format, arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.log(Level.INFO, format, arg1, arg2);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.log(Level.INFO, format, arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.log(Level.INFO, msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return false;
    }

    @Override
    public void warn(String msg) {
        this.log(Level.WARNING, msg, new Object[0]);
    }

    @Override
    public void warn(String format, Object arg) {
        this.log(Level.WARNING, format, arg);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.log(Level.WARNING, format, arguments);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.log(Level.WARNING, format, arg1, arg2);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.log(Level.WARNING, msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return false;
    }

    @Override
    public void error(String msg) {
        this.log(Level.SEVERE, msg, new Object[0]);
    }

    @Override
    public void error(String format, Object arg) {
        this.log(Level.SEVERE, format, arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.log(Level.SEVERE, format, arg1, arg2);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.log(Level.SEVERE, format, arguments);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log(Level.SEVERE, msg, t);
    }
}

