/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.smartboot.http.common.utils.ByteTree;
import org.smartboot.http.common.utils.StringUtils;

public class HttpUtils {
    public static void decodeParamString(String paramStr, Map<String, String[]> paramMap) {
        String[] uriParamStrArray;
        if (StringUtils.isBlank(paramStr)) {
            return;
        }
        for (String param : uriParamStrArray = StringUtils.split(paramStr, "&")) {
            int index = param.indexOf("=");
            if (index == -1) continue;
            try {
                String key = StringUtils.substring(param, 0, index);
                String value = URLDecoder.decode(StringUtils.substring(param, index + 1), "utf8");
                String[] values = paramMap.get(key);
                if (values == null) {
                    paramMap.put(key, new String[]{value});
                    continue;
                }
                String[] newValue = new String[values.length + 1];
                System.arraycopy(values, 0, newValue, 0, values.length);
                newValue[values.length] = value;
                paramMap.put(key, newValue);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getString(ByteBuffer buffer, ByteTree.EndMatcher endMatcher) {
        int position = buffer.position() + buffer.arrayOffset();
        int limit = buffer.limit() + buffer.arrayOffset();
        byte[] data = buffer.array();
        for (int i = position; i < limit; ++i) {
            if (!endMatcher.match(data[i])) continue;
            String str = new String(data, position, i++ - position, StandardCharsets.US_ASCII);
            while (data[i] == 32) {
                ++i;
            }
            buffer.position(i - buffer.arrayOffset());
            return str;
        }
        return null;
    }
}

