/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.api;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.sonar.runner.api.LogOutput;
import org.sonar.runner.cache.Logger;

class LoggerAdapter
implements Logger {
    private LogOutput logOutput;

    LoggerAdapter(LogOutput logOutput) {
        this.logOutput = logOutput;
    }

    @Override
    public void warn(String msg) {
        this.logOutput.log(msg, LogOutput.Level.WARN);
    }

    @Override
    public void info(String msg) {
        this.logOutput.log(msg, LogOutput.Level.INFO);
    }

    @Override
    public void error(String msg, Throwable t) {
        StringWriter errors = new StringWriter();
        t.printStackTrace(new PrintWriter(errors));
        this.logOutput.log(msg + "\n" + errors.toString(), LogOutput.Level.ERROR);
    }

    @Override
    public void error(String msg) {
        this.logOutput.log(msg, LogOutput.Level.ERROR);
    }

    @Override
    public void debug(String msg) {
        this.logOutput.log(msg, LogOutput.Level.DEBUG);
    }
}

