/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.parsing.EmptyReaderEventListener;
import org.springframework.beans.factory.parsing.FailFastProblemReporter;
import org.springframework.beans.factory.parsing.NullSourceExtractor;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.ReaderEventListener;
import org.springframework.beans.factory.parsing.SourceExtractor;
import org.springframework.beans.factory.support.AbstractBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.DefaultDocumentLoader;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.springframework.beans.factory.xml.DocumentLoader;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionParser;
import org.springframework.beans.factory.xml.XmlBeanDefinitionStoreException;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.Constants;
import org.springframework.core.io.DescriptiveResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.xml.SimpleSaxErrorHandler;
import org.springframework.util.xml.XmlValidationModeDetector;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlBeanDefinitionReader
extends AbstractBeanDefinitionReader {
    public static final int VALIDATION_NONE = 0;
    public static final int VALIDATION_AUTO = 1;
    public static final int VALIDATION_DTD = 2;
    public static final int VALIDATION_XSD = 3;
    private static final Constants constants = new Constants(class$org$springframework$beans$factory$xml$XmlBeanDefinitionReader == null ? (class$org$springframework$beans$factory$xml$XmlBeanDefinitionReader = XmlBeanDefinitionReader.class$("org.springframework.beans.factory.xml.XmlBeanDefinitionReader")) : class$org$springframework$beans$factory$xml$XmlBeanDefinitionReader);
    private boolean namespaceAware;
    private int validationMode = 1;
    private Class parserClass;
    private Class documentReaderClass = class$org$springframework$beans$factory$xml$DefaultBeanDefinitionDocumentReader == null ? (class$org$springframework$beans$factory$xml$DefaultBeanDefinitionDocumentReader = XmlBeanDefinitionReader.class$("org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader")) : class$org$springframework$beans$factory$xml$DefaultBeanDefinitionDocumentReader;
    private ProblemReporter problemReporter = new FailFastProblemReporter();
    private ReaderEventListener eventListener = new EmptyReaderEventListener();
    private SourceExtractor sourceExtractor = new NullSourceExtractor();
    private NamespaceHandlerResolver namespaceHandlerResolver;
    private DocumentLoader documentLoader = new DefaultDocumentLoader();
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler = new SimpleSaxErrorHandler(this.logger);
    private final XmlValidationModeDetector validationModeDetector = new XmlValidationModeDetector();
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$XmlBeanDefinitionReader;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$DefaultBeanDefinitionDocumentReader;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$BeanDefinitionDocumentReader;

    public XmlBeanDefinitionReader(BeanDefinitionRegistry beanFactory) {
        super(beanFactory);
        this.entityResolver = this.getResourceLoader() != null ? new ResourceEntityResolver(this.getResourceLoader()) : new DelegatingEntityResolver(ClassUtils.getDefaultClassLoader());
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public void setValidating(boolean validating) {
        this.validationMode = validating ? 1 : 0;
    }

    public void setValidationModeName(String validationModeName) {
        this.setValidationMode(constants.asNumber(validationModeName).intValue());
    }

    public void setValidationMode(int validationMode) {
        this.validationMode = validationMode;
    }

    public void setProblemReporter(ProblemReporter problemReporter) {
        this.problemReporter = problemReporter != null ? problemReporter : new FailFastProblemReporter();
    }

    public void setEventListener(ReaderEventListener eventListener) {
        this.eventListener = eventListener != null ? eventListener : new EmptyReaderEventListener();
    }

    public void setSourceExtractor(SourceExtractor sourceExtractor) {
        this.sourceExtractor = sourceExtractor != null ? sourceExtractor : new NullSourceExtractor();
    }

    public void setNamespaceHandlerResolver(NamespaceHandlerResolver namespaceHandlerResolver) {
        this.namespaceHandlerResolver = namespaceHandlerResolver;
    }

    public void setDocumentLoader(DocumentLoader documentLoader) {
        this.documentLoader = documentLoader != null ? documentLoader : new DefaultDocumentLoader();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setParserClass(Class parserClass) {
        if (this.parserClass == null || !(class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser == null ? (class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser = XmlBeanDefinitionReader.class$("org.springframework.beans.factory.xml.XmlBeanDefinitionParser")) : class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser).isAssignableFrom(parserClass)) {
            throw new IllegalArgumentException("'parserClass' must be an XmlBeanDefinitionParser");
        }
        this.parserClass = parserClass;
    }

    public void setDocumentReaderClass(Class documentReaderClass) {
        if (documentReaderClass == null || !(class$org$springframework$beans$factory$xml$BeanDefinitionDocumentReader == null ? (class$org$springframework$beans$factory$xml$BeanDefinitionDocumentReader = XmlBeanDefinitionReader.class$("org.springframework.beans.factory.xml.BeanDefinitionDocumentReader")) : class$org$springframework$beans$factory$xml$BeanDefinitionDocumentReader).isAssignableFrom(documentReaderClass)) {
            throw new IllegalArgumentException("documentReaderClass must be an implementation of the BeanDefinitionDocumentReader interface");
        }
        this.documentReaderClass = documentReaderClass;
    }

    public int loadBeanDefinitions(Resource resource) throws BeanDefinitionStoreException {
        return this.loadBeanDefinitions(new EncodedResource(resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadBeanDefinitions(EncodedResource encodedResource) throws BeanDefinitionStoreException {
        int n;
        Assert.notNull((Object)encodedResource, (String)"EncodedResource must not be null");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Loading XML bean definitions from " + encodedResource.getResource()));
        }
        InputStream inputStream = encodedResource.getResource().getInputStream();
        try {
            InputSource inputSource = new InputSource(inputStream);
            if (encodedResource.getEncoding() != null) {
                inputSource.setEncoding(encodedResource.getEncoding());
            }
            n = this.doLoadBeanDefinitions(inputSource, encodedResource.getResource());
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("IOException parsing XML document from " + encodedResource.getResource(), ex);
            }
        }
        inputStream.close();
        return n;
    }

    public int loadBeanDefinitions(InputSource inputSource) throws BeanDefinitionStoreException {
        return this.loadBeanDefinitions(inputSource, "resource loaded through SAX InputSource");
    }

    public int loadBeanDefinitions(InputSource inputSource, String resourceDescription) throws BeanDefinitionStoreException {
        return this.doLoadBeanDefinitions(inputSource, (Resource)new DescriptiveResource(resourceDescription));
    }

    protected int doLoadBeanDefinitions(InputSource inputSource, Resource resource) throws BeanDefinitionStoreException {
        try {
            int validationMode = this.getValidationModeForResource(resource);
            Document doc = this.documentLoader.loadDocument(inputSource, this.entityResolver, this.errorHandler, validationMode, this.namespaceAware);
            return this.registerBeanDefinitions(doc, resource);
        }
        catch (BeanDefinitionStoreException ex) {
            throw ex;
        }
        catch (SAXParseException ex) {
            throw new XmlBeanDefinitionStoreException(resource.getDescription(), "Line " + ex.getLineNumber() + " in XML document from " + resource + " is invalid", ex);
        }
        catch (SAXException ex) {
            throw new XmlBeanDefinitionStoreException(resource.getDescription(), "XML document from " + resource + " is invalid", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new BeanDefinitionStoreException(resource.getDescription(), "Parser configuration exception parsing XML from " + resource, ex);
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException(resource.getDescription(), "IOException parsing XML document from " + resource, ex);
        }
        catch (Throwable ex) {
            throw new BeanDefinitionStoreException(resource.getDescription(), "Unexpected exception parsing XML document from " + resource, ex);
        }
    }

    private int getValidationModeForResource(Resource resource) {
        if (this.validationMode != 1) {
            return this.validationMode;
        }
        int detectedMode = this.detectValidationMode(resource);
        if (detectedMode != 1) {
            return detectedMode;
        }
        return 3;
    }

    protected int detectValidationMode(Resource resource) {
        InputStream inputStream;
        if (resource.isOpen()) {
            throw new BeanDefinitionStoreException("Passed-in Resource [" + resource + "] contains an open stream: " + "cannot determine validation mode automatically. Either pass in a Resource " + "that is able to create fresh streams, or explicitly specify the validationMode " + "on your XmlBeanDefinitionReader instance.");
        }
        try {
            inputStream = resource.getInputStream();
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("Unable to determine validation mode for [" + resource + "]: cannot open InputStream. " + "Did you attempt to load directly from a SAX InputSource without specifying the " + "validationMode on your XmlBeanDefinitionReader instance?", ex);
        }
        try {
            return this.validationModeDetector.detectValidationMode(inputStream);
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("Unable to determine validation mode for [" + resource + "]: an error occurred whilst reading from the InputStream.", ex);
        }
    }

    public int registerBeanDefinitions(Document doc, Resource resource) throws BeanDefinitionStoreException {
        if (this.parserClass != null) {
            XmlBeanDefinitionParser parser = (XmlBeanDefinitionParser)BeanUtils.instantiateClass(this.parserClass);
            return parser.registerBeanDefinitions(this, doc, resource);
        }
        BeanDefinitionDocumentReader documentReader = this.createBeanDefinitionDocumentReader();
        int countBefore = this.getBeanFactory().getBeanDefinitionCount();
        documentReader.registerBeanDefinitions(doc, this.createReaderContext(resource));
        return this.getBeanFactory().getBeanDefinitionCount() - countBefore;
    }

    protected BeanDefinitionDocumentReader createBeanDefinitionDocumentReader() {
        return (BeanDefinitionDocumentReader)BeanUtils.instantiateClass(this.documentReaderClass);
    }

    protected XmlReaderContext createReaderContext(Resource resource) {
        NamespaceHandlerResolver resolver = this.namespaceHandlerResolver;
        if (resolver == null) {
            resolver = this.createDefaultNamespaceHandlerResolver();
        }
        return new XmlReaderContext(resource, this.problemReporter, this.eventListener, this.sourceExtractor, this, resolver);
    }

    protected NamespaceHandlerResolver createDefaultNamespaceHandlerResolver() {
        return new DefaultNamespaceHandlerResolver(this.getResourceLoader().getClassLoader());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

