/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzWlo;
import com.aspose.words.internal.zzXqx;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzZ5i;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzZ5i zzWz9;

    BorderCollection(zzZ5i parent) {
        this.zzWz9 = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzWlo.zzYcZ(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzNm().equals(brColl.zzNm()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzWz9.getPossibleBorderKeys().zzZ2u(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzWz9.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzWz9, borderKey);
            this.zzWz9.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzWz9.getPossibleBorderKeys().zzX4i().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzWz9.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzWz9.getPossibleBorderKeys().zzX4i().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzYDE(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzWz9.getPossibleBorderKeys().zzX4i().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzYDE(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzNm().zz2J();
    }

    public final void setColor(Color value) throws Exception {
        this.zziX(zzXqx.zz0l(value));
    }

    private zzXqx zzNm() throws Exception {
        return this.get(0).zzNm();
    }

    private void zziX(zzXqx zzXqx2) throws Exception {
        Iterator iterator = this.zzWz9.getPossibleBorderKeys().zzX4i().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzYDE(n)) continue;
            this.getByBorderType(n).zziX(zzXqx2);
        }
    }

    final boolean zzWDc(int n) {
        return this.zzWz9.getPossibleBorderKeys().zzKX(n);
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzWz9.getPossibleBorderKeys().zzX4i().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzYDE(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzWz9.getPossibleBorderKeys().zzX4i().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzYDE(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzZ2u(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzYDE(int n) {
        return n != 6 && n != 7;
    }

    static final class zzZ2u
    implements Iterator<Border> {
        private BorderCollection zzRd;
        private int zzWLR;

        zzZ2u(BorderCollection borderCollection) {
            this.zzRd = borderCollection;
            this.zzWLR = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzWLR >= this.zzRd.getCount() - 1) {
                return false;
            }
            ++this.zzWLR;
            return true;
        }

        private Border zzYul() {
            try {
                return this.zzRd.get(this.zzWLR);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzYul();
        }
    }
}

