/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzWlo;
import com.aspose.words.zzW8S;
import com.aspose.words.zzWeN;
import com.aspose.words.zzWt6;
import com.aspose.words.zzXS8;
import com.aspose.words.zzXpV;
import com.aspose.words.zzYGy;
import com.aspose.words.zzYqJ;
import com.aspose.words.zzZCL;
import com.aspose.words.zzZH1;
import com.aspose.words.zzZJZ;

public class Cell
extends CompositeNode<Node>
implements zzXpV,
zzZCL {
    private zzW8S zzZmW;
    private CellFormat zzXYt;
    private ParagraphCollection zzXoW;
    private TableCollection zzrj;

    public Cell(DocumentBase doc) {
        this(doc, new zzW8S());
    }

    Cell(DocumentBase doc, zzW8S cellPr) {
        super(doc);
        this.zzZmW = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    public Cell getNextCell() {
        return (Cell)this.zzqR();
    }

    public Cell getPreviousCell() {
        return (Cell)this.zzWp();
    }

    public Row getParentRow() {
        return (Row)this.zzZ0y();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzYZY() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zztT(this, true);
        }
        return -1;
    }

    final int zzWwO() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzWwO();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzXYt == null) {
            this.zzXYt = new CellFormat(this);
        }
        return this.zzXYt;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzXoW == null) {
            this.zzXoW = new ParagraphCollection(this);
        }
        return this.zzXoW;
    }

    public TableCollection getTables() {
        if (this.zzrj == null) {
            this.zzrj = new TableCollection(this);
        }
        return this.zzrj;
    }

    final zzW8S zzWp9() {
        return this.zzZmW;
    }

    final void zzZ2u(zzW8S zzW8S2) {
        this.zzZmW = zzW8S2;
    }

    @Override
    final Node zzZ2u(boolean bl, zzYGy zzYGy2) {
        zzW8S zzW8S2;
        Cell cell = (Cell)super.zzZ2u(bl, zzYGy2);
        zzW8S zzW8S3 = this.zzZmW;
        cell.zzZmW = zzW8S2 = (zzW8S)zzW8S3.zzYCe();
        cell.zzXYt = null;
        cell.zzXoW = null;
        cell.zzrj = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellStart(this);
    }

    @Override
    public int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzZJZ.zzXwp(this);
    }

    @Override
    final boolean zzWgc(Node node) {
        return zzYqJ.zzZlC(node);
    }

    final int zzYMo() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        for (Cell cell = row.getFirstCell(); cell != null; cell = cell.getNextCell()) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell != this) continue;
            return n;
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZmW.zzXYK(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzZmW.zzXYK(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzWeN zzWeN2 = zzWlo.zzZ2u(object, zzWeN.class);
        if (zzWeN2 != null && zzWeN2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzZn8(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzW8S.zzNR(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzZmW.zzYCC(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZmW.clear();
    }

    private Object zzZn8(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzWlo.zzZ2u((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzZ2u(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXS8 getInsertRevision() {
        Cell cell = this;
        return cell.zzZmW.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzXS8 value) {
        Cloneable cloneable = this;
        zzXS8 zzXS82 = value;
        cloneable = cloneable.zzZmW;
        ((zzZH1)cloneable).zzYCC(14, zzXS82);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXS8 getDeleteRevision() {
        Cell cell = this;
        return cell.zzZmW.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzXS8 value) {
        Cloneable cloneable = this;
        zzXS8 zzXS82 = value;
        cloneable = cloneable.zzZmW;
        ((zzZH1)cloneable).zzYCC(12, zzXS82);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWt6 getMoveFromRevision() {
        Cell cell = this;
        return cell.zzZmW.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzWt6 value) {
        Cloneable cloneable = this;
        zzWt6 zzWt62 = value;
        cloneable = cloneable.zzZmW;
        ((zzZH1)cloneable).zzYCC(13, zzWt62);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWt6 getMoveToRevision() {
        Cell cell = this;
        return cell.zzZmW.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzWt6 value) {
        Cloneable cloneable = this;
        zzWt6 zzWt62 = value;
        cloneable = cloneable.zzZmW;
        ((zzZH1)cloneable).zzYCC(15, zzWt62);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzZmW.remove(13);
        cell = this;
        cell.zzZmW.remove(15);
    }

    final zzW8S zzWbn(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzW8S zzW8S2 = new zzW8S();
        this.zzZ2u(3120, zzW8S2);
        this.zzZ2u(3140, zzW8S2);
        this.zzZ2u(3110, zzW8S2);
        this.zzZ2u(3130, zzW8S2);
        this.zzZ2u(3090, zzW8S2);
        this.zzZ2u(3100, zzW8S2);
        this.zzZ2u(3070, zzW8S2);
        this.zzZ2u(3080, zzW8S2);
        if (bl && (tableStyle = zzWlo.zzZ2u((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zz0l(this, zzW8S2);
        }
        this.zzZmW.zz0l((zzZH1)zzW8S2);
        return zzW8S2;
    }

    private void zzZ2u(int n, zzW8S zzW8S2) {
        zzW8S2.zzYCC(n, this.fetchInheritedCellAttr(n));
    }
}

