/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CommentCollection;
import com.aspose.words.CommentRangeEnd;
import com.aspose.words.CommentRangeStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.InlineStory;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zzWlo;
import com.aspose.words.internal.zzZoS;
import com.aspose.words.internal.zzhW;
import com.aspose.words.zzWt6;
import com.aspose.words.zzWvR;
import com.aspose.words.zzXMZ;
import com.aspose.words.zzYUG;
import com.aspose.words.zzZat;
import com.aspose.words.zzhf;
import java.util.ArrayList;
import java.util.Date;

public final class Comment
extends InlineStory
implements zzWvR,
zzXMZ {
    private int zzWA;
    private boolean zzWmM;
    private boolean zzYiD;
    private int zzWRO;
    private int zzY6y = -1;
    private String zzZWH = "";
    private String zzid = "";
    private zzhW zzYID = zzhW.zzar;
    private zzhW zzX7L = zzhW.zzar;
    private CommentCollection zzYVv;

    Comment(DocumentBase doc, zzhf runPr) {
        super(doc, runPr);
        this.zzWRO = doc.zzWg();
    }

    public Comment(DocumentBase doc) {
        this(doc, "", "", zzhW.zzar);
    }

    private Comment(DocumentBase doc, String author, String initial, zzhW dateTime) {
        this(doc, new zzhf());
        this.setAuthor(author);
        this.setInitial(initial);
        zzhW zzhW2 = dateTime;
        Comment comment = this;
        this.zzYID = zzhW2;
        this.getFont().setStyleIdentifier(39);
    }

    public Comment(DocumentBase doc, String author, String initial, Date dateTime) {
        this(doc, author, initial, zzhW.zzZ2u(dateTime));
    }

    @Override
    public final int getNodeType() {
        return 19;
    }

    @Override
    public final int getStoryType() {
        return 4;
    }

    public final int getId() {
        return this.zzWRO;
    }

    public final void setId(int value) {
        this.zzWRO = value;
        if (this.getDocument() != null) {
            this.getDocument().zzZGZ();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getIdInternal() {
        return this.getId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setIdInternal(int value) {
        this.setId(value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getParentIdInternal() {
        return this.getParentId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setParentIdInternal(int value) {
        this.setParentId(value);
    }

    public final String getInitial() {
        return this.zzZWH;
    }

    public final void setInitial(String value) {
        zzWlo.zz0l((Object)value, "Initial");
        this.zzZWH = value;
    }

    public final Date getDateTime() {
        Comment comment = this;
        return zzhW.zzYcZ(comment.zzYID);
    }

    private void zzZsr(zzhW zzhW2) {
        this.zzYID = zzhW2;
        if (!zzhW.zzZ2u(this.zzX7L, zzhW.zzar)) {
            this.zzX7L = !zzhW.zzZ2u(zzhW2, zzhW.zzar) ? zzhW2.zzYh9() : zzhW.zzar;
        }
    }

    public final void setDateTime(Date value) {
        this.zzZsr(zzhW.zzZ2u(value));
    }

    final zzhW zzZAS() {
        if (!zzhW.zzZ2u(this.zzX7L, zzhW.zzar)) {
            return this.zzX7L;
        }
        if (!zzhW.zzZ2u(this.zzYID, zzhW.zzar)) {
            return this.zzYID.zzYh9();
        }
        return zzhW.zzar;
    }

    public final Date getDateTimeUtc() {
        return zzhW.zzYcZ(this.zzZAS());
    }

    final void zzWqo(zzhW zzhW2) {
        this.zzX7L = zzhW2;
    }

    public final String getAuthor() {
        return this.zzid;
    }

    public final void setAuthor(String value) {
        zzWlo.zz0l((Object)value, "Author");
        this.zzid = value;
    }

    final zzhW zzZbN() {
        return this.zzYID;
    }

    final void zzZH1(zzhW zzhW2) {
        this.zzYID = zzhW2;
    }

    final boolean zzY0C() {
        return !zzhW.zzZ2u(this.zzX7L, zzhW.zzar);
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    private Comment zzZ2u(String string, String string2, zzhW zzhW2, String string3) throws Exception {
        if (this.getParentId() != -1) {
            throw new IllegalStateException("Cannot add a reply to another reply.");
        }
        if (this.getParentNode() == null) {
            throw new IllegalStateException("No parent node.");
        }
        Comment comment = new Comment(this.getDocument(), string, string2, zzhW2);
        comment.setIdInternal(zzYUG.zzZ2u(this.getDocument()));
        comment.setParentId(this.zzWRO);
        comment.setText(string3);
        Comment comment2 = this;
        Comment comment3 = zzWlo.zzZ2u((Object)this.zzXYj(), Comment.class);
        while (comment3 != null && comment3.getParentId() == this.zzWRO) {
            comment2 = comment3;
            comment3 = zzWlo.zzZ2u((Object)comment3.zzXYj(), Comment.class);
        }
        this.getParentNode().insertAfter(comment, comment2);
        zzZat zzZat2 = new zzZat();
        if (zzZat2.zz0l(this.getDocument(), this.zzWRO)) {
            this.zzZ2u(zzZat2.zzYEQ(), new CommentRangeStart(this.getDocument(), comment.getId()));
            this.zzZ2u(zzZat2.zzZtq(), new CommentRangeEnd(this.getDocument(), comment.getId()));
        }
        return comment;
    }

    public final Comment addReply(String author, String initial, Date dateTime, String text) throws Exception {
        return this.zzZ2u(author, initial, zzhW.zzZ2u(dateTime), text);
    }

    private void zzZ2u(CommentRangeStart commentRangeStart, CommentRangeStart commentRangeStart2) {
        Node node2;
        ArrayList arrayList = new ArrayList();
        for (Node node2 : this.getReplies()) {
            zzZoS.zzZ2u(arrayList, Integer.valueOf(node2.getId()));
        }
        Object object = commentRangeStart;
        while (((Node)object).getNextSibling() != null && ((Node)(node2 = ((Node)object).getNextSibling())).getNodeType() == 33 && arrayList.contains(((CommentRangeStart)node2).getId())) {
            object = node2;
        }
        ((Node)object).zz8i(commentRangeStart2);
    }

    private void zzZ2u(CommentRangeEnd commentRangeEnd, CommentRangeEnd commentRangeEnd2) {
        ArrayList arrayList = new ArrayList();
        for (Node node : this.getReplies()) {
            if (((Comment)node).getId() == commentRangeEnd2.getId()) continue;
            zzZoS.zzZ2u(arrayList, Integer.valueOf(((Comment)node).getId()));
        }
        Object object = commentRangeEnd;
        while (((Node)object).getNextSibling() != null) {
            int n;
            Node node;
            node = ((Node)object).getNextSibling();
            if (node.getNodeType() == 34) {
                n = ((CommentRangeEnd)node).getId();
            } else {
                if (node.getNodeType() != 19) break;
                n = ((Comment)node).getId();
            }
            if (!arrayList.contains(n) && n != this.zzWRO) break;
            object = node;
        }
        ((Node)object).zz8i(commentRangeEnd2);
    }

    public final void removeReply(Comment reply) throws Exception {
        zzZat zzZat2 = new zzZat();
        if (zzZat2.zz0l(this.getDocument(), reply.getId())) {
            zzZat2.zzYEQ().remove();
            zzZat2.zzZtq().remove();
        }
        reply.remove();
    }

    public final void removeAllReplies() throws Exception {
        for (Comment comment : this.getReplies().zzWxS()) {
            this.removeReply(comment);
        }
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentEnd(this);
    }

    public final void setText(String text) {
        this.removeAllChildren();
        Paragraph paragraph = new Paragraph(this.getDocument());
        paragraph.getParagraphFormat().setStyleIdentifier(30);
        this.appendChild(paragraph);
        DocumentBuilder documentBuilder = new DocumentBuilder(this.zzZ1v());
        documentBuilder.moveTo(paragraph);
        SpecialChar specialChar = new SpecialChar(this.zzZ1v(), '\u0005', new zzhf());
        specialChar.getFont().setStyleIdentifier(39);
        documentBuilder.insertNode(specialChar);
        documentBuilder.write(text);
    }

    public final Comment getAncestor() {
        if (this.getDocument() == null || this.getParentId() == -1) {
            return null;
        }
        for (Comment comment : this.getDocument().getChildNodes(19, true)) {
            if (comment.getId() != this.getParentId()) continue;
            return comment;
        }
        return null;
    }

    public final CommentCollection getReplies() {
        if (this.zzYVv == null) {
            this.zzYVv = new CommentCollection(this.getDocument(), this);
        }
        return this.zzYVv;
    }

    public final boolean getDone() {
        return this.zzYiD;
    }

    public final void setDone(boolean value) {
        this.zzYiD = value;
    }

    public final int getParentId() {
        return this.zzY6y;
    }

    public final void setParentId(int value) {
        this.zzY6y = value;
        if (this.getDocument() != null) {
            this.getDocument().zzZGZ();
        }
    }

    final int zzZvo() {
        return this.zzWA;
    }

    final void zzWYk(int n) {
        this.zzWA = n;
    }

    final boolean zzWRG() {
        return this.zzWmM;
    }

    final void zzXXQ(boolean bl) {
        this.zzWmM = bl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzWt6 getMoveFromRevision() {
        return this.zzYd6().getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveFromRevision(zzWt6 value) {
        zzWt6 zzWt62 = value;
        zzhf zzhf2 = this.zzYd6();
        zzhf2.zzYCC(13, zzWt62);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzWt6 getMoveToRevision() {
        return this.zzYd6().getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveToRevision(zzWt6 value) {
        zzWt6 zzWt62 = value;
        zzhf zzhf2 = this.zzYd6();
        zzhf2.zzYCC(15, zzWt62);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void removeMoveRevisions() {
        this.zzYd6().remove(13);
        this.zzYd6().remove(15);
    }

    final String zzX3D() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzYu0(stringBuilder);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '\u0005') {
            stringBuilder.delete(0, 1);
        }
        return stringBuilder.toString();
    }
}

