/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzWlo;
import com.aspose.words.zzVRw;
import com.aspose.words.zzW4v;
import com.aspose.words.zzWES;
import com.aspose.words.zzWHQ;
import com.aspose.words.zzWX8;
import com.aspose.words.zzYGy;
import com.aspose.words.zzYqJ;
import com.aspose.words.zzZ9W;
import com.aspose.words.zzZEi;
import java.util.Iterator;

public abstract class CompositeNode<V extends Node>
extends Node
implements zzZEi,
Iterable<V> {
    private Node zzZ9O;
    private Node zzXrh;
    private Node zzYo1;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzW4v zzW4v2 = new zzW4v(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzYjU(this, true);
            return;
        }
        finally {
            zzW4v2.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzWHn() {
        return this.zzZ07() != null;
    }

    final boolean zzZF9() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzXC8() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzWX8) {
                return true;
            }
            CompositeNode compositeNode = zzWlo.zzZ2u((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzXC8()) continue;
            return true;
        }
        return false;
    }

    public Node getFirstChild() {
        return this.zzZ9O;
    }

    public Node getLastChild() {
        return this.zzXrh;
    }

    final Node zzZ07() {
        return zzYqJ.zzlp(this.getFirstChild(), false);
    }

    final Node zzXZ6() {
        return zzYqJ.zzYCC(this.getLastChild(), false);
    }

    final CompositeNode zz2S() {
        return (CompositeNode)zzYqJ.zzlp(this.getFirstChild(), true);
    }

    final CompositeNode zzWiq() {
        return (CompositeNode)zzYqJ.zzYCC(this.getLastChild(), true);
    }

    final Node zzYBS() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzYqJ.zzZjm((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzXoi() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzYqJ.zzZjm((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzZ2u(boolean bl, zzYGy zzYGy2) {
        CompositeNode compositeNode = (CompositeNode)super.zzZ2u(bl, zzYGy2);
        ((CompositeNode)super.zzZ2u(bl, zzYGy2)).zzXrh = null;
        compositeNode.zzZ9O = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzq7(node.zzZ2u(true, zzYGy2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzYu0(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzYu0(StringBuilder stringBuilder) {
        this.zzWlm(stringBuilder);
        zzWlo.zz0l(stringBuilder, this.zzZMk());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zz0l(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, bl);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzYqJ.zzXTI(nodeType);
            Node node2 = node = bl ? this.zzZ07() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzYvf() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzVRw.zzBF(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzVRw.zzYjU(this, xpath);
    }

    @Override
    public Iterator<V> iterator() {
        return new zzWHQ(this);
    }

    public <T extends Node> T appendChild(T newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public <T extends Node> T prependChild(T newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public <T extends Node> T insertAfter(T newChild, Node refChild) {
        return this.zzZ2u(newChild, refChild, true);
    }

    public <T extends Node> T insertBefore(T newChild, Node refChild) {
        return this.zzZ2u(newChild, refChild, false);
    }

    public <T extends Node> T removeChild(T oldChild) {
        return this.zzYjU(oldChild, false);
    }

    private <T extends Node> T zzYjU(T t, boolean bl) {
        if (t == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (t.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = zzYqJ.zzZ2u(documentBase, t, (Node)this, null, 1);
        DocumentBase documentBase2 = documentBase;
        if (documentBase2.zzqK() && zzYqJ.zzXq5(t)) {
            return t;
        }
        zzYqJ.zzZ2u(documentBase, nodeChangingArgs);
        if (!bl && zzYqJ.zzWvS(t)) {
            zzYqJ.zzYaB(t, false);
        }
        T t2 = this.zzWUB(t);
        zzYqJ.zz0l(documentBase, nodeChangingArgs);
        return t2;
    }

    public void removeAllChildren() {
        zzWES.zzeC(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzq7(Node node) {
        node.getParentNode();
        if (this.zzXrh == null) {
            node.zzlo(null);
            node.zzXbW(null);
            this.zzZ9O = node;
        } else {
            node.zzlo(this.zzXrh);
            node.zzXbW(null);
            this.zzXrh.zzXbW(node);
        }
        this.zzXrh = node;
        node.zzWDv(this);
        return node;
    }

    final void zzZ2u(Node node, Node node2, Node node3) {
        this.zzZ2u(node, node2, node3, false);
    }

    final void zzZ2u(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzWgc(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zz0l(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zztT(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzYqJ.zzZjm(node3.getNodeType())) continue;
            if (zzYqJ.zzYCn(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzZMk().length();
    }

    String zzZMk() {
        return "";
    }

    final String zzZW8() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzWlm(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzWlm(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzYu0(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.acceptStart(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.acceptEnd(visitor));
    }

    public abstract int acceptStart(DocumentVisitor var1) throws Exception;

    public abstract int acceptEnd(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    boolean zzWgc(Node node) {
        return true;
    }

    final <T extends Node> T zzZ2u(T t, Node node, boolean bl) {
        Object object;
        if (node != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (t == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (t == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzYM3(t)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (t == node) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = t.getDocument();
        zzYqJ.zz0l(documentBase, documentBase2);
        if (t.getNodeType() != 37 && !this.zzWgc(t)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = t.getParentNode();
        Node node2 = t.getNextSibling();
        if (compositeNode != null) {
            object = new zzZ9W(documentBase);
            try {
                compositeNode.zzYjU(t, true);
            }
            finally {
                ((zzZ9W)object).dispose();
            }
        }
        object = zzYqJ.zzZ2u(documentBase, t, null, (Node)this, 0);
        zzYqJ.zzZ2u(documentBase, (NodeChangingArgs)object);
        if (this.zzXrh == null) {
            t.zzlo(null);
            t.zzXbW(null);
            this.zzZ9O = t;
            this.zzXrh = t;
        } else if (bl) {
            if (node != null) {
                this.zz0l(t, node);
            } else {
                this.zzBF(t, this.zzZ9O);
            }
        } else if (node != null) {
            this.zzBF(t, node);
        } else {
            this.zz0l(t, this.zzXrh);
        }
        t.zzWDv(this);
        zzYqJ.zz0l(documentBase, (NodeChangingArgs)object);
        DocumentBase documentBase3 = documentBase;
        if (documentBase3.zzqK()) {
            zzYqJ.zzZ2u(t, compositeNode, node2);
        }
        return t;
    }

    private void zz0l(Node node, Node node2) {
        Node node3 = node2.zzXIn();
        node.zzlo(node2);
        node.zzXbW(node3);
        node2.zzXbW(node);
        if (node3 == null) {
            this.zzXrh = node;
            return;
        }
        node3.zzlo(node);
    }

    private void zzBF(Node node, Node node2) {
        Node node3 = node2.zzZIw();
        node.zzlo(node3);
        node.zzXbW(node2);
        node2.zzlo(node);
        if (node3 == null) {
            this.zzZ9O = node;
            return;
        }
        node3.zzXbW(node);
    }

    private <T extends Node> T zzWUB(T t) {
        if (t == this.zzZ9O) {
            if (this.zzZ9O == this.zzXrh) {
                this.zzZ9O = null;
                this.zzXrh = null;
            } else {
                this.zzZ9O = t.zzXIn();
                this.zzZ9O.zzlo(null);
            }
        } else {
            Node node = t.zzZIw();
            Node node2 = t.zzXIn();
            node.zzXbW(node2);
            if (node2 == null) {
                this.zzXrh = node;
            } else {
                node2.zzlo(node);
            }
        }
        t.zzXbW(null);
        t.zzlo(null);
        t.zzWDv(null);
        return t;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzYo1 = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYo1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

