/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzG8;
import com.aspose.words.internal.zzWAU;
import com.aspose.words.internal.zzWSJ;
import com.aspose.words.internal.zzWlo;
import com.aspose.words.internal.zzX1v;
import com.aspose.words.internal.zzXDp;
import com.aspose.words.internal.zzXTc;
import com.aspose.words.internal.zzXg6;
import com.aspose.words.internal.zzY3p;
import com.aspose.words.internal.zzZAU;
import com.aspose.words.internal.zzqg;
import com.aspose.words.internal.zzs6;
import com.aspose.words.zz4z;
import com.aspose.words.zzAR;
import com.aspose.words.zzFk;
import com.aspose.words.zzQv;
import com.aspose.words.zzVSx;
import com.aspose.words.zzW3P;
import com.aspose.words.zzWTe;
import com.aspose.words.zzWd;
import com.aspose.words.zzWph;
import com.aspose.words.zzZ9b;
import com.aspose.words.zzZAZ;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzZ2u(zzZAU zzZAU2, zzZAU zzZAU3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzWlo.zz0l((Object)zzZAU2, "srcStream");
        zzWlo.zz0l((Object)zzZAU3, "dstStream");
        zzWlo.zz0l((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zz0l(zzZAU2, zzZAU3, certificateHolder, signOptions);
        zzZAU3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzZ2u(zzZAU.zz0l(srcStream), (zzZAU)zzZAU.zzBF(dstStream), certHolder, signOptions);
    }

    private static void zz0l(zzZAU zzZAU2, zzZAU zzZAU3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzBF(digitalSignature);
        }
        if (zzWd.zzYho(zzZAU2)) {
            DigitalSignatureUtil.zzZ2u(zzZAU2, zzZAU3, digitalSignature, true);
            return;
        }
        zzWd zzWd2 = new zzWd();
        zzZAU zzZAU4 = zzZAU2;
        zzWd zzWd3 = zzWd2;
        FileFormatInfo fileFormatInfo = zzWd2.zz0l(zzZAU4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzG8 zzG82 = new zzG8(zzZAU2);
                int n = fileFormatInfo.zzZkE() == 1 ? 1 : 2;
                zzW3P.zzZ2u(zzG82, digitalSignature, n);
                zzZAU3.zzhh(0L);
                zzG82.zzXwp(zzZAU3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzZ2u(fileFormatInfo.zzWVM(), zzZAU3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzZ2u(zzZAU2, zzZAU3, digitalSignature, false);
                return;
            }
            case 60: 
            case 61: {
                DigitalSignatureUtil.zzZ2u(zzZAU2, zzZAU3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzWlo.zzBF(srcFileName, "srcFileName");
        zzWlo.zzBF(dstFileName, "dstFileName");
        try (zzXDp zzXDp2 = zzWlo.zz0l(srcFileName, 3, 1);){
            try (zzXDp zzXDp3 = zzWlo.zz0l(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzZ2u((zzZAU)zzXDp2, (zzZAU)zzXDp3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzqg zzqg2 = zzZAU.zzBF(dstStream);
        zzZAU zzZAU2 = zzZAU.zz0l(srcStream);
        DigitalSignatureUtil.zzZ2u(zzZAU2, (zzZAU)zzqg2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzXDp zzXDp2 = zzWlo.zz0l(srcFileName, 3, 1);){
            try (zzXDp zzXDp3 = zzWlo.zz0l(dstFileName, 4, 2);){
                DigitalSignatureUtil.zztT(zzXDp2, zzXDp3);
            }
            return;
        }
    }

    private static void zztT(zzZAU zzZAU2, zzZAU zzZAU3) throws Exception {
        zzWd zzWd2 = new zzWd();
        zzZAU zzZAU4 = zzZAU2;
        Object object = zzWd2;
        FileFormatInfo fileFormatInfo = zzWd2.zz0l(zzZAU4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzG8 zzG82 = new zzG8(zzZAU2);
                zzG82.zzWi5().zzZ8Y("_xmlsignatures");
                zzG82.zzWi5().zzZ8Y("_signatures");
                zzZAU3.zzq7(0L);
                zzG82.zzXwp(zzZAU3);
                zzZAU zzZAU5 = zzZAU3;
                zzZAU5.zzhh(zzZAU5.zzWal());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzWSJ zzWSJ2 = new zzWSJ(zzZAU2);
                zzX1v zzX1v2 = zzWSJ2.zzZ2u(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzX1v2 != null) {
                    for (zzWAU zzWAU2 : zzX1v2.zzY24()) {
                        String string = zzX1v2.zzZ2u(zzWAU2);
                        zzWSJ2.zzBX().remove(string);
                    }
                    zzWSJ2.zzBX().remove(zzX1v2.getName());
                    zzWAU zzWAU3 = zzWSJ2.zzY24().zzXXQ("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzWSJ2.zzY24().remove(zzWAU3.getId());
                    zzWSJ2.zzYkN();
                }
                zzZAU3.zzq7(0L);
                zzWSJ2.zzXwp(zzZAU3);
                zzZAU zzZAU6 = zzZAU3;
                zzZAU6.zzhh(zzZAU6.zzWal());
                return;
            }
            case 60: 
            case 61: {
                zzWph zzWph2 = new zzWph(zzZAU2);
                zzAR zzAR2 = zzWph2.zzE6("/META-INF/documentsignatures.xml");
                if (zzAR2 != null) {
                    zzWph2.zzWbV().remove(zzAR2.getName());
                }
                zzZAU3.zzq7(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzZAU4 = zzZAU3;
                object = zzWph2;
                ((zzWph)object).zzZ2u(zzZAU4, string, null);
                zzZAU zzZAU7 = zzZAU3;
                zzZAU7.zzhh(zzZAU7.zzWal());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zztT(zzZAU.zz0l(srcStream), zzZAU.zzBF(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzXDp zzXDp2 = zzWlo.zz0l(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzWx7(zzXDp2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzWx7(zzZAU zzZAU2) throws Exception {
        if (zzWd.zzYho(zzZAU2)) {
            return DigitalSignatureUtil.zzWEx(zzZAU2);
        }
        zzWd zzWd2 = new zzWd();
        zzZAU zzZAU3 = zzZAU2;
        zzWd zzWd3 = zzWd2;
        FileFormatInfo fileFormatInfo = zzWd2.zz0l(zzZAU3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzZAU2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzWx7(zzZAU.zz0l(stream));
    }

    static zzs6 zzZ2u(zzG8 zzG82, String string) throws Exception {
        zzZ9b zzZ9b2 = new zzZ9b(zzG82);
        if (zzZ9b2.zzZaz()) {
            zzs6 zzs62 = zzZ9b2.zzWcu(string);
            return zzs62;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzZMP(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzXg6.zz0l("Unexpected digest algorithm: {0}.", n));
    }

    static String zzZZO(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzZMP(n);
    }

    private static void zzZ2u(zzZAU zzZAU2, zzZAU zzZAU3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzWSJ zzWSJ2 = new zzWSJ(zzZAU2);
        zzQv zzQv2 = bl ? new zzWTe(zzWSJ2) : new zzZAZ(zzWSJ2);
        zzQv2.zz0l(digitalSignature);
        zzZAU3.zzhh(0L);
        zzWSJ2.zzXwp(zzZAU3);
    }

    private static void zzZ2u(zzZAU zzZAU2, zzZAU zzZAU3, DigitalSignature digitalSignature) throws Exception {
        zzWph zzWph2 = new zzWph(zzZAU2);
        zzVSx zzVSx2 = new zzVSx(zzWph2);
        zzVSx2.zz0l(digitalSignature);
        zzZAU3.zzhh(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzZAU zzZAU4 = zzZAU3;
        zzWph zzWph3 = zzWph2;
        zzWph3.zzZ2u(zzZAU4, string, null);
    }

    private static void zzZ2u(zzG8 zzG82, zzZAU zzZAU2, DigitalSignature digitalSignature, String string) throws Exception {
        zzs6 zzs62 = DigitalSignatureUtil.zzZ2u(zzG82, string);
        zzs6 zzs63 = new zzs6();
        DigitalSignatureUtil.zzZ2u((zzZAU)zzs62, (zzZAU)zzs63, digitalSignature, false);
        zzG8 zzG83 = zzZ9b.zztT(zzs63, string);
        zzG83.zzXwp(zzZAU2);
    }

    private static DigitalSignatureCollection zzWEx(zzZAU zzZAU2) throws Exception {
        zzZAU2.zzq7(0L);
        zzWSJ zzWSJ2 = new zzWSJ(zzZAU2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzX1v zzX1v2 = zzWSJ2.zzZ2u(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzX1v2 != null) {
            for (zzWAU zzWAU2 : zzX1v2.zzY24()) {
                String string = zzX1v2.zzZ2u(zzWAU2);
                zzX1v zzX1v3 = zzWSJ2.zz7i(string);
                zzX1v zzX1v4 = zzWSJ2.zzZ2u(zzX1v3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzXTc zzXTc2 = zzY3p.zzXwp(zzX1v4.zzZZb().zzZ96());
                zz4z.zzZ2u(zzX1v3.zzt6(), zzXTc2, new zzFk(zzWSJ2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

