/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zz9j;
import com.aspose.words.internal.zzVU6;
import com.aspose.words.internal.zzWCA;
import com.aspose.words.internal.zzWlo;
import com.aspose.words.internal.zzWw0;
import com.aspose.words.internal.zzXDZ;
import com.aspose.words.internal.zzXg6;
import com.aspose.words.internal.zzXsW;
import com.aspose.words.internal.zzXvM;
import com.aspose.words.internal.zzYK2;
import com.aspose.words.internal.zzYPN;
import com.aspose.words.internal.zzYY4;
import com.aspose.words.internal.zzYp9;
import com.aspose.words.internal.zzYus;
import com.aspose.words.internal.zzYzs;
import com.aspose.words.internal.zzZAU;
import com.aspose.words.internal.zzqy;
import com.aspose.words.internal.zzs6;
import com.aspose.words.zz2o;
import com.aspose.words.zz3I;
import com.aspose.words.zzAc;
import com.aspose.words.zzOP;
import com.aspose.words.zzP7;
import com.aspose.words.zzPH;
import com.aspose.words.zzRR;
import com.aspose.words.zzVRA;
import com.aspose.words.zzVWo;
import com.aspose.words.zzVZ2;
import com.aspose.words.zzVZJ;
import com.aspose.words.zzW8S;
import com.aspose.words.zzWLD;
import com.aspose.words.zzWQF;
import com.aspose.words.zzWUS;
import com.aspose.words.zzWc;
import com.aspose.words.zzWme;
import com.aspose.words.zzWoQ;
import com.aspose.words.zzXA2;
import com.aspose.words.zzXEQ;
import com.aspose.words.zzXMK;
import com.aspose.words.zzXQ7;
import com.aspose.words.zzXen;
import com.aspose.words.zzXpV;
import com.aspose.words.zzXr8;
import com.aspose.words.zzXvW;
import com.aspose.words.zzYAL;
import com.aspose.words.zzYJV;
import com.aspose.words.zzYKi;
import com.aspose.words.zzYdq;
import com.aspose.words.zzYhc;
import com.aspose.words.zzYjW;
import com.aspose.words.zzYmB;
import com.aspose.words.zzYqJ;
import com.aspose.words.zzYrZ;
import com.aspose.words.zzYza;
import com.aspose.words.zzZ9W;
import com.aspose.words.zzZCL;
import com.aspose.words.zzZH1;
import com.aspose.words.zzZJZ;
import com.aspose.words.zzZsr;
import com.aspose.words.zzZy2;
import com.aspose.words.zze;
import com.aspose.words.zzhf;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzWLD,
zzWQF,
zzXpV,
zzYhc {
    private Document zzXAK;
    private Node zzZ2i;
    private Node zzX5u;
    private zzhf zzWjs;
    private Font zzXu4;
    private zzYPN<zzhf> zzXJm;
    private zzYPN<zzZy2> zznH;
    private zzYPN<zzZ2u> zzWKO;
    private zzWme zzXJc = zzWme.zzVWz();
    private zzW8S zzZmW = new zzW8S();
    private zzZy2 zzYgx;
    private RowFormat zzXxR;
    private CellFormat zzXYt;
    private ParagraphFormat zzY82;
    private zzYPN<zz3I> zzZJG;
    private int zzW9w = 0;
    private int zzk4 = -1;
    private int zzYtE;
    private boolean zzYck;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzlp(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzlp(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzlp(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZ2u(documentBuilder.getCurrentSection(), zzZJZ.zzOp(headerFooterType), 0, 0);
    }

    private void zzlp(int n, int n2, int n3, int n4) {
        this.zzXAK.ensureMinimum();
        Section section = (Section)this.zzXAK.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzZ2u(section, 1, n3, n4);
    }

    private void zzZ2u(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzZJZ.zzZv4(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = section.appendChild(new HeaderFooter(this.zzXAK, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzXAK));
            }
        }
        this.zzZ2u(story, n2, n3);
    }

    private void zzZ2u(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZ2u((CompositeNode)paragraph2, n3);
    }

    final void zzZ2u(Paragraph paragraph, int n) {
        this.zzZ2u((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldName");
        }
        FieldMergeField fieldMergeField = this.zzZVx().zziy() ? zzXA2.zzWgc(this.zzXAK, fieldName) : zzXA2.zzZIh(this.zzZVx(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzZ2u(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzZ2u(field, isAfter, false);
    }

    private boolean zzZ2u(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzYmB zzYmB2 = field.getFormat().zzYa5();
        Inline inline = zzYmB2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzZ2u(inline.zzYd6(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: bookmarkName");
        }
        Node node = isStart ? zzRR.zzZ2u(this.zzXAK, bookmarkName) : zzRR.zz0l(this.zzXAK, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzZiu() == 6) {
            this.zzZ2u(node.zzZ0y(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzYqJ.zzWgI(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzZ2u((CompositeNode)paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZ2u(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zz0l(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzZ2u(structuredDocumentTag);
            return;
        }
        this.zzBF(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzW8U(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzZ2u((CompositeNode)cell, characterIndex);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzZiu() == 6) {
            this.zzZsr(node);
        } else {
            Node node2 = node;
            if (zzYqJ.zzZjm(node2.getNodeType())) {
                Paragraph paragraph = zzYqJ.zzWgI(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzZsr(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzZiu() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzZsr(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzYtE = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzY3G();
            return;
        }
        if (!this.zzZzw()) {
            this.zzY3G();
        }
    }

    private void zzZ2u(CompositeNode compositeNode, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(compositeNode);
    }

    private boolean zzZzw() {
        Node node = this.zzZVx();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzZVx().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzZ2u(((StructuredDocumentTag)documentBuilder.zzZVx().getParentNode()).zzYO7(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzZVx(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzZ2u(inline.zzYd6(), true);
            return true;
        }
        return false;
    }

    private void zzY3G() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZ2u(documentBuilder.getCurrentParagraph().zzXBX(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzW8U(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzZnh() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzZVx().zzYM3(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzqR();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzZ2u((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzZsr(text, false);
    }

    public void writeln(String text) {
        this.zzZsr(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        if (this.zzZVx() != null && this.zzZVx().zzZiu() == 6 && (this.isAtEndOfStructuredDocumentTag() || this.zzZVx().getParentNode() instanceof StructuredDocumentTag)) {
            throw new IllegalStateException("Cannot insert a node of this type at this location.");
        }
        this.zzYgL();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzZ9W zzZ9W2 = new zzZ9W(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzXAK, this.zzZOp(), this.zznw());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().zz8i(paragraph);
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zz0l(this.zzZVx(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzZ9W2.dispose();
        }
        if (this.getDocument().zzqK()) {
            zzYqJ.zzBF((zzZCL)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzYWZ());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzVYo() {
        zzhf zzhf2;
        Run run;
        Run run2;
        zzWQF zzWQF2;
        this.zzYgL();
        Node node = this.zzZVx();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            zzWQF2 = paragraph;
            run2 = zzWQF2.zzZCe(false);
        } else {
            run2 = run = (Run)node.zzW1I(21);
        }
        if (run2 == null && zzWlo.zzYcZ(node, paragraph.zzXmM())) {
            run = paragraph.zzXmM();
        }
        if (run != null) {
            zzWQF2 = run.zzYd6();
            zzhf2 = (zzhf)((zzZH1)((Object)zzWQF2)).zzYCe();
        } else {
            zzWQF2 = paragraph.zzXBX();
            zzhf2 = (zzhf)((zzZH1)((Object)zzWQF2)).zzYCe();
        }
        zzhf zzhf3 = zzhf2;
        Paragraph paragraph2 = new Paragraph(this.zzXAK, this.zzZOp(), zzhf3);
        paragraph.zzDB(paragraph2);
        zzZ9W zzZ9W2 = new zzZ9W(this.zzXAK);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zz0l(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzZ9W2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zze.zzWgc(this);
    }

    public void insertBreak(int breakType) {
        this.zzP3(breakType, true);
    }

    final void zzP3(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzZBn(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zz8f(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzWPn())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzZBn(bl)) {
                        this.zz8f(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzZBn(bl)) {
                        this.zzVQa(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzZBn(bl)) {
                        this.zzVQa(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzZBn(bl)) {
                        this.zzVQa(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzZBn(bl)) {
                        this.zzVQa(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzZBn(bl)) {
                        this.zzVQa(4);
                    }
                    return;
                }
                case 8: {
                    this.zz8f(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zz9j.zzz(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzXg6.zz0l("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzYgL();
        return zzYqJ.zzZ2u(fieldType, updateField, this.zznw(), this.zzdG(), this.zzWnQ(), this.zzWnQ() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzYgL();
        return zzYqJ.zzZ2u(fieldCode, this.zznw(), this.zzdG(), this.zzWnQ(), this.zzWnQ() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzYgL();
        return zzYqJ.zzZ2u(fieldCode, fieldValue, this.zznw(), this.zzdG(), this.zzWnQ(), this.zzWnQ() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzWlo.zz0l((Object)displayText, "displayText");
        zzWlo.zz0l((Object)urlOrBookmark, "hrefOrBookmark");
        zzP7 zzP72 = this.zz0l(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        Object object = this;
        zzP72.zzBF(((DocumentBuilder)object).zzY38(88, true));
        object = zzP72;
        return zzYqJ.zzZ2u((zzP7)object);
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (format == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzWRe(70);
        if (zz9j.zzz(name)) {
            this.startBookmark(name);
        }
        this.zzXKK(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzZib(70);
        String string = zz9j.zzz(fieldValue) ? fieldValue : FormField.zzX2J;
        Run run = new Run(this.zzXAK, string, this.zznw());
        this.insertNode(run);
        Node node = this.zzY38(70, true);
        if (zz9j.zzz(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzXRn(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzZ2u((CompositeNode)((Paragraph)node.zzZ0y()), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzWRe(71);
        if (zz9j.zzz(name)) {
            this.startBookmark(name);
        }
        this.zzXKK(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzY38(71, false);
        if (zz9j.zzz(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXRn(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (items == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzWRe(83);
        if (zz9j.zzz(name)) {
            this.startBookmark(name);
        }
        this.zzXKK(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzY38(83, false);
        if (zz9j.zzz(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXRn(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzXAK, footnoteType, !zz9j.zzz(referenceMark), referenceMark, this.zznw());
        Style style = this.getDocument().getStyles().zzYTR(zzYqJ.zzWgv(footnoteType));
        footnote.zzYd6().set(50, style.zzYSe());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzXAK);
        Style style2 = this.getDocument().getStyles().zzYTR(zzYqJ.zzYXC(footnoteType));
        paragraph.zzXHo().set(1000, style2.zzYSe());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzXAK, '\u0002', new zzhf()) : new Run(this.zzXAK, footnote.getReferenceMark(), new zzhf());
        inline.zzYd6().set(50, style.zzYSe());
        paragraph.appendChild(inline);
        if (zz9j.zzz(footnoteText)) {
            Node node = this.zzZVx();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzZsr(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzZkq(zzZAU zzZAU2) throws Exception {
        return this.zzZ2u(zzZAU2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzZkq(zzZAU.zz0l(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzZ2u(zzZAU zzZAU2, double d, double d2) throws Exception {
        return this.zzZ2u(zzZAU2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzZ2u(zzZAU.zz0l(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: image");
        }
        try (zzs6 zzs62 = new zzs6();){
            zzYp9.zzZ2u(image, zzs62);
            Shape shape = this.zzZ2u(zzs62, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzWlo.zzBF(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzYus.zzMP(fileName);
        try {
            Shape shape = this.zzZ2u((zzZAU)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzZAU)object).close();
            }
        }
    }

    private Shape zzZ2u(zzZAU zzZAU2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzZAU2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        byte[] byArray = zzWlo.zzZIh(zzZAU2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZ2u(zzZAU.zz0l(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZ2u(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzZ2u(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        boolean bl2 = false;
        if (zzXsW.zzZWf(object)) {
            object4 = new zzYp9((byte[])object);
            bl2 = true;
            ((zzWCA)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzXAK.getCompatibilityOptions().getMswVersion() > 12 || this.zzXAK.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzXAK, 0);
            object3 = new zzWUS();
            ((zzYAL)object3).zzZ2u(zzYKi.zzZfx("rect"));
            ((zzWUS)object3).zzZ2u(new zzWc());
            ((zzWUS)object3).zzW4l().zzXdu().zzBF(this.zzXAK);
            object2 = new zzWoQ();
            ((zzYJV)object2).zz0l(new zz2o(this.zzXAK.zzXVK(), ""));
            ((zzYJV)object2).zzZ2u(new zzYza());
            ((zzOP)object3).zzZ2u((zzYJV)object2);
            shape.setShapeType(75);
            shape.zzYCn((zzOP)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzXAK, 75);
        }
        if (zzXsW.zzZkq(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzZ2u((byte[])object, new zzAc(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzAc(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzXsW.zzX1J((byte[])object2));
                this.zzZ2u((zzWUS)shape.zzWF4(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzWUS)shape.zzWF4()).zzW4l().zzXdu().zzWZq((byte[])object);
            object3 = zzXsW.zz7b(object);
            object4 = new zzAc(((zzXDZ)object3).getWidthPoints(), ((zzXDZ)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zz0l(this.zznw());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzXsW.zzWgI(object)) {
            d5 = DocumentBuilder.zzZ2u(shape, object);
        }
        shape.zzZ2u(d3, d4, (zzAc)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzZ2u(Shape shape, byte[] byArray) throws Exception {
        int n = zzXsW.zzWo5(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzYqJ.zzYY3(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzYqJ.zzeb(n);
        return d;
    }

    private void zzZ2u(zzWUS zzWUS2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzWUS2.zzW4l().zzXdu().getExtensions();
        try (zzs6 zzs62 = new zzs6(byArray);){
            object = zzYqJ.zzZ2u(zzs62, this.zzXAK);
            ((zzYrZ)object).zzZXl(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzYrZ)object).zziI();
            byArray2 = ((zzYrZ)object).zzZZM(true);
        }
        zzWUS2.zzW4l().zzXdu().setExtensions(new zzVU6<zzVZ2>());
        object = zzVZ2.zzZ2u(byArray2, this.zzXAK);
        zzWUS2.zzW4l().zzXdu().getExtensions().zzBF(((zzVZ2)object).getUri(), (zzVZ2)object);
    }

    private Shape zzZ2u(zzZAU zzZAU2, String string, boolean bl, zzZAU zzZAU3) throws Exception {
        zzXMK zzXMK2 = zzXMK.zzWi(string);
        Shape shape = this.zzZ2u(zzZAU3, bl, zzXMK2, null);
        zzXr8 zzXr82 = zzXvW.zzZ2u(zzZAU2, string, bl);
        return DocumentBuilder.zzZ2u(null, false, shape, zzXMK2.zzZbh, zzXr82);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzZ2u(zzZAU.zz0l(stream), progId, asIcon, zzZAU.zz0l(presentation));
    }

    private Shape zzZ2u(String string, boolean bl, boolean bl2, zzZAU zzZAU2) throws Exception {
        zzXMK zzXMK2 = zzXMK.zzWRJ(zzWw0.zzWg4(string));
        return this.zzZ2u(string, bl, bl2, zzZAU2, zzXMK2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzZ2u(fileName, isLinked, asIcon, zzZAU.zz0l(presentation));
    }

    private Shape zzZ2u(String string, String string2, boolean bl, boolean bl2, zzZAU zzZAU2) throws Exception {
        zzXMK zzXMK2 = zzXMK.zzWi(string2);
        return this.zzZ2u(string, bl, bl2, zzZAU2, zzXMK2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzZ2u(fileName, progId, isLinked, asIcon, zzZAU.zz0l(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzXMK zzXMK2 = zzXMK.zzWRJ(zzWw0.zzWg4(fileName));
        return this.zzZ2u(fileName, isLinked, iconFile, iconCaption, zzXMK2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzXMK zzXMK2 = zzXMK.zzWi(progId);
        return this.zzZ2u(fileName, isLinked, iconFile, iconCaption, zzXMK2);
    }

    private Shape zz0l(zzZAU zzZAU2, String string, String string2, String string3) throws Exception {
        zzXMK zzXMK2 = zzXMK.zzWi(string);
        Shape shape = this.zzZ2u(string2, string3, zzXMK2);
        zzXr8 zzXr82 = zzXvW.zzZ2u(zzZAU2, string, true);
        return DocumentBuilder.zzZ2u(null, false, shape, zzXMK2.zzZbh, zzXr82);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zz0l(zzZAU.zz0l(stream), progId, iconFile, iconCaption);
    }

    final Shape zzZ2u(zzVWo zzVWo2, zzZAU zzZAU2) throws Exception {
        Shape shape = this.zzXmo(zzZAU2);
        shape.setShapeType(201);
        shape.zzX6U(4112, zzVWo2);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzYgL();
        if (this.zzWVY()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzXju(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzXen zzXen2 = zzYqJ.zzZ2u(html, options, this);
        zzXen2.zzZlk();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzYgL();
        return zzYqJ.zzZ2u(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzYgL();
        return zzYqJ.zzZ2u(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzVRA zzVRA2 = new zzVRA();
        return zzVRA2.zzZ2u(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzXEQ(this).zzZ2u(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzXEQ(this).zzZ2u(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzXAK, 75);
        shape.zz0l(this.zznw());
        shape.zzZ2Y(true);
        shape.getSignatureLine().zzZ2u(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzZna(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzRR(this.zzXAK);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzWVY() {
        boolean bl = false;
        if (this.zzZVx().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzZVx().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzXju(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzYgL();
        if (this.zzZnh() == null) {
            this.startTable();
        }
        if (this.zzZnh().zzZ1g() == 1) {
            this.zzZnh().zzXIF();
        }
        if (this.zzZnh().zzZ1g() == 3) {
            this.zzZnh().zzFl();
        }
        return this.zzZnh().zzyD();
    }

    public Table startTable() {
        this.zzZJG.push(new zz3I(this));
        return this.zzZnh().startTable();
    }

    public Table endTable() {
        if (this.zzZnh() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzZnh().endTable();
        this.zzZJG.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzZnh() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzZnh().endRow();
        if (this.zzXu4 != null && this.zzXu4.getHidden()) {
            row.zzW6N().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzXAK, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzXAK, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzoB();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzXAK, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzYMo();
        bookmarkStart.zzU8(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzoB();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzYMo();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzXAK, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzZZ2(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzXAK);
        this.zzk4 = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzk4 == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzXAK, this.zzk4);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzXAK, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzWlo.zz0l((Object)importFormatOptions, "ImportFormatOptions");
        this.zzYgL();
        return zzYjW.zzZ2u(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Node insertDocumentInline(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzWlo.zz0l((Object)importFormatOptions, "ImportFormatOptions");
        this.zzYgL();
        importFormatOptions.zzWBY(true);
        Node node = zzYjW.zzZ2u(this, srcDoc, importFormatMode, importFormatOptions);
        importFormatOptions.zzWBY(false);
        return node;
    }

    public Document getDocument() {
        return this.zzXAK;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzXAK) {
            return;
        }
        this.zzXAK = value;
        this.zzZsr(null);
        this.zzWjs = new zzhf();
        this.zzXJm = null;
        this.zznH = null;
        this.zzXu4 = null;
        this.zzZJG = new zzYPN();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzXu4 == null) {
            DocumentBuilder documentBuilder = this;
            this.zzXu4 = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzXu4;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzY82 == null) {
            DocumentBuilder documentBuilder = this;
            this.zzY82 = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zzY82;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzXxR == null) {
            this.zzXxR = new RowFormat(this);
        }
        return this.zzXxR;
    }

    public CellFormat getCellFormat() {
        if (this.zzXYt == null) {
            this.zzXYt = new CellFormat(this);
        }
        return this.zzXYt;
    }

    final void zzaV(Node node) {
        this.getCurrentParagraph().zzDB(node);
    }

    public void pushFont() {
        zzhf zzhf2;
        if (this.getCurrentParagraph() != null) {
            zzhf zzhf3 = this.getCurrentParagraph().zzXBX();
            zzhf2 = (zzhf)zzhf3.zzYCe();
        } else {
            zzhf2 = this.zznw();
        }
        zzhf zzhf4 = zzhf2;
        this.zzYY2().push(new zzZ2u(this.zznw(), zzhf4));
    }

    public void popFont() {
        zzYPN<zzZ2u> zzYPN2 = this.zzYY2();
        if (zzYPN2.size() > 0) {
            zzZ2u zzZ2u2 = (zzZ2u)this.zzYY2().pop();
            this.zzZ2u(zzZ2u2.zzYd6(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzq7(zzZ2u2.zzYVS());
            }
        }
    }

    final void zzZcK() {
        this.zzYwh().push(this.zznw());
    }

    final void zzZiO() {
        zzYPN<zzhf> zzYPN2 = this.zzYwh();
        if (zzYPN2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzZ2u((zzhf)documentBuilder.zzYwh().pop(), false);
        }
    }

    final void zzWoo() {
        this.zzVRz().push(this.zzZOp());
    }

    final void zzYc6() {
        zzYPN<zzZy2> zzYPN2 = this.zzVRz();
        if (zzYPN2.size() > 0) {
            zzZy2 zzZy22 = (zzZy2)this.zzVRz().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzZ2u(zzZy22);
            }
        }
    }

    private zzP7 zz0l(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzWRe(88);
        zzPH zzPH2 = new zzPH();
        zzPH2.setTarget(string2);
        zzPH2.setScreenTip(string3);
        if (bl) {
            zzPH2.setSubAddress(string);
        } else {
            zzPH2.setAddress(zzXvM.zzXt4(string));
            zzPH2.setSubAddress(zzXvM.zzW06(string));
        }
        this.zzXKK(zzPH2.zzyu());
        FieldSeparator fieldSeparator = this.zzZib(88);
        return new zzP7(fieldStart, fieldSeparator, null);
    }

    final zzP7 zzYxE(String string, String string2, String string3) {
        boolean bl = zzXvM.zzYIg(string);
        String string4 = bl ? zzXvM.zzW06(string) : string;
        return this.zz0l(string4, bl, string2, string3);
    }

    final zzP7 zzZ2u(zzPH zzPH2) {
        FieldStart fieldStart = this.zzWRe(88);
        this.zzXKK(zzPH2.zzyu());
        FieldSeparator fieldSeparator = this.zzZib(88);
        return new zzP7(fieldStart, fieldSeparator, null);
    }

    final FieldEnd zzYxD() {
        return this.zzY38(88, true);
    }

    final zzhf zznw() {
        zzhf zzhf2 = this.zzWjs;
        return (zzhf)zzhf2.zzYCe();
    }

    final zzZy2 zzZOp() {
        zzZy2 zzZy22 = this.zzXHo();
        return (zzZy2)zzZy22.zzYCe();
    }

    final zzWme zzBq() {
        zzWme zzWme2 = this.zzW6N();
        return (zzWme)zzWme2.zzYCe();
    }

    final zzW8S zzWW8() {
        zzW8S zzW8S2 = this.zzWp9();
        return (zzW8S)zzW8S2.zzYCe();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzZVx(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzZVx().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzYck && this.zzZVx().getNodeType() == 28;
    }

    private void zzZsr(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzZVx()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzZJZ.zzXeh(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzZdo(string2.substring(n4, n4 + n2));
                }
                switch (this.zzW9w) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zz8f(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzZdo(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzYgL();
        if (this.zzZnh() != null && this.zzZnh().zzZ1g() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzZVx().zzDB(node);
    }

    final void zz4C(int n) {
        this.zzZBn(true);
        this.zzVQa(n);
    }

    private void zzVQa(int n) {
        this.insertParagraph();
        zzZ9W zzZ9W2 = new zzZ9W(this.getDocument());
        try {
            zzVZJ zzVZJ2 = this.getCurrentSection().zzXH8();
            zzVZJ zzVZJ3 = (zzVZJ)zzVZJ2.zzYCe();
            Section section = new Section(this.zzXAK, zzVZJ3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzXAK));
            this.zzXAK.insertAfter(section, this.getCurrentSection());
            section.getBody().zz0l(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzZ9W2.dispose();
        }
    }

    final FieldStart zzWRe(int n) {
        this.zzYgL();
        return zzYqJ.zzZ2u(n, this.zznw(), this.zzdG(), this.zzWnQ(), this.zzWnQ() == null);
    }

    final Run zzXKK(String string) {
        return zzYqJ.zz0l(string, this.zznw(), this.zzdG(), this.zzWnQ(), this.zzWnQ() == null);
    }

    final FieldEnd zzY38(int n, boolean bl) {
        return zzYqJ.zz0l(n, bl, this.zznw(), this.zzdG(), this.zzWnQ(), this.zzWnQ() == null);
    }

    final FieldSeparator zzZib(int n) {
        return zzYqJ.zz0l(n, this.zznw(), this.zzdG(), this.zzWnQ(), this.zzWnQ() == null);
    }

    private FormField zzXRn(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzXAK, new zzXQ7(), this.zznw());
        CompositeNode compositeNode = node == null ? this.zzdG() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzZBn(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzZnh() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzW8U(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzZdo(String string) {
        if (this.zzY5t(string)) {
            zzYK2 zzYK22 = new zzYK2(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzYzs zzYzs2 : zzYK22.zzdm(this.getParagraphFormat().getBidi())) {
                zzZsr zzZsr2 = zzZsr.zzXWX(zzYzs2.zzXAJ());
                zzhf zzhf2 = this.zznw();
                zzhf2.zzYCC(265, zzZsr2);
                if (zzYzs2.zzZVQ()) {
                    zzhf2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzXAK, zzYzs2.getText(), zzhf2);
                this.insertNode(run);
            }
            return;
        }
        this.zz8f(string);
    }

    private boolean zzY5t(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzYY4.zzXxg(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzZ2u(zzhf zzhf2, boolean bl) {
        zzhf zzhf3;
        if (bl) {
            zzhf zzhf4 = zzhf2;
            zzhf3 = (zzhf)zzhf4.zzYCe();
        } else {
            zzhf3 = zzhf2;
        }
        this.zzWjs = zzhf3;
    }

    final void zzXYV() {
        this.zzWjs.clear();
    }

    final void zzXCt() {
        if (this.zzoB() != null) {
            zzW8S zzW8S2;
            zzW8S zzW8S3 = zzW8S2 = this.zzoB().zzWp9();
            this.zzZmW = (zzW8S)zzW8S3.zzYCe();
            zzW8S2.zz0l(this.zzZmW);
        }
    }

    private Shape zzZ2u(String string, boolean bl, boolean bl2, zzZAU zzZAU2, zzXMK zzXMK2) throws Exception {
        if (zzXMK2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        Shape shape = this.zzZ2u(zzZAU2, bl2, zzXMK2, string);
        zzXr8 zzXr82 = zzXvW.zzZ2u(string, bl, bl2, zzXMK2);
        return DocumentBuilder.zzZ2u(string, bl, shape, zzXMK2.zzZbh, zzXr82);
    }

    private Shape zzZ2u(String string, boolean bl, String string2, String string3, zzXMK zzXMK2) throws Exception {
        if (zzXMK2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string3 == null) {
            string3 = zzWw0.zzWdn(string);
        }
        Shape shape = string2 != null ? this.zzWFd(string2, string3) : this.zzZ2u(null, string3, zzXMK2);
        zzXr8 zzXr82 = zzXvW.zzZ2u(string, bl, true, zzXMK2);
        return DocumentBuilder.zzZ2u(string, bl, shape, zzXMK2.zzZbh, zzXr82);
    }

    private static Shape zzZ2u(String string, boolean bl, Shape shape, String string2, zzXr8 zzXr82) {
        if (shape == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: insertedOleImage");
        }
        shape.setShapeType(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zz0l(zzXr82);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzZ2u(zzZAU zzZAU2, boolean bl, zzXMK zzXMK2, String string) throws Exception {
        if (zzXMK2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (zzZAU2 != null) {
            return this.zzXmo(zzZAU2);
        }
        if (!bl) {
            return this.zzWtj(zzXvW.zzXeS().get("normal"));
        }
        String string2 = string != null ? zzWw0.zzWdn(string) : zzXvW.zz5v(zzXMK2.zzYQB);
        return this.zzZ2u(zzXMK2, string2);
    }

    private Shape zzZ2u(String string, String string2, zzXMK zzXMK2) throws Exception {
        if (zzXMK2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string2 == null) {
            string2 = zzXvW.zz5v(zzXMK2.zzYQB);
        }
        if (string != null) {
            return this.zzWFd(string, string2);
        }
        return this.zzZ2u(zzXMK2, string2);
    }

    private Shape zzZ2u(zzXMK zzXMK2, String string) throws Exception {
        if (zzXMK2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        byte[] byArray = zzXvW.zzZeb(zzXMK2.zzYQB);
        zzqy zzqy2 = new zzqy(byArray, null, string, this.getDocument().zzZs3());
        return this.zzWtj(zzqy2.zzZJu());
    }

    private Shape zzWFd(String string, String string2) throws Exception {
        zzqy zzqy2 = new zzqy(string, string2, this.getDocument().zzZs3());
        return this.zzWtj(zzqy2.zzZJu());
    }

    private Shape zzXmo(zzZAU zzZAU2) throws Exception {
        byte[] byArray = zzWlo.zzZIh(zzZAU2);
        return this.zzWtj(byArray);
    }

    private Shape zzWtj(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzXAK, 1);
        shape.setShapeType(75);
        shape.zz0l(this.zznw());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzZna(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzZ2u(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zz0l(compositeNode, n);
            return;
        }
        this.zzBF(compositeNode, n);
    }

    private void zz0l(CompositeNode compositeNode, int n) {
        zzYdq zzYdq2 = zzYdq.zzZNW(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzYdq2.zzZ2u(null, true, true, true, false, true);
            node = zzYdq2.getNode();
            if (zzYdq2.zzX1a() && (!node.isComposite() || node.zzZiu() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzZMk().length() : node.getTextLength();
            if (!zzYdq2.zzX1a() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzYdq2.zzX1a() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzZ2u((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzZ2u(null, node);
            this.zzYtE = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzZ2u(StructuredDocumentTag structuredDocumentTag) {
        this.zzZsr(structuredDocumentTag);
        this.zzYck = true;
        this.zzYtE = 0;
        zzhf zzhf2 = structuredDocumentTag.zzYO7();
        switch (structuredDocumentTag.zzZiu()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzXoi(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzhf2 = ((Inline)node).zzYd6();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzhf2 = paragraph.zzXBX();
                break;
            }
            default: {
                return;
            }
        }
        this.zzZ2u(zzhf2, true);
    }

    private void zzBF(CompositeNode compositeNode, int n) {
        zzYdq zzYdq2 = zzYdq.zzVUZ(compositeNode);
        while (zzYdq2.getNode() != compositeNode || !zzYdq2.zzX1a()) {
            int n2;
            Node node = zzYdq2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzZMk().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzZ2u(null, node);
                this.zzYtE = n;
                return;
            }
            while (zzYdq2.zzZ2u(null, false, true, true, false, true) && zzYdq2.zzX1a() && zzYdq2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzYgL() {
        int n = this.zzYtE;
        if (n == 0) {
            return;
        }
        this.zzYtE = 0;
        Run run = zzWlo.zzZ2u((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzYQE(n);
        }
    }

    private Run zz8f(String string) {
        Run run = new Run(this.zzXAK, string, this.zznw());
        this.insertNode(run);
        return run;
    }

    final boolean zzYO1() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzZJi() {
        return this.zzW9w;
    }

    final void zzWSS(int n) {
        this.zzW9w = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzZVx();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzZVx();
        }
        return (Paragraph)this.zzZVx().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzZVx();
        }
        return (StructuredDocumentTag)this.zzZVx().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzZVx().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zz3I zzZnh() {
        return zzWlo.zzZ2u(this.zzZJG);
    }

    private Cell zzoB() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzXnD();
    }

    private CompositeNode zzdG() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzZVx();
        }
        return this.zzZVx().getParentNode();
    }

    private Node zzWnQ() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzZVx();
    }

    private zzYPN<zzhf> zzYwh() {
        if (this.zzXJm == null) {
            this.zzXJm = new zzYPN();
        }
        return this.zzXJm;
    }

    private zzYPN<zzZy2> zzVRz() {
        if (this.zznH == null) {
            this.zznH = new zzYPN();
        }
        return this.zznH;
    }

    private zzYPN<zzZ2u> zzYY2() {
        if (this.zzWKO == null) {
            this.zzWKO = new zzYPN();
        }
        return this.zzWKO;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzWjs.zzXYK(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzWjs.zzYVE(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzW8a(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzW8a(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzWjs.zzYCC(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzVW3()) {
            this.getCurrentParagraph().zzXBX().zzYCC(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzWjs.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzWjs.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzVW3()) {
            this.getCurrentParagraph().zzXBX().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzXHo().zzXYK(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzXHo().zzYVE(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzOz(key, 0);
        }
        return this.getDocument().getStyles().zzXfy().zzWW1(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzXHo().zzYCC(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzXHo().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzXHo().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzW6N().zzXYK(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzW6N().zzWW1(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzW6N().zzaB(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzW6N().zzYCC(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzW6N().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzW6N().clear();
        zzWme.zzVWz().zz0l(this.zzW6N());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzWp9().zzXYK(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzWp9().zzWW1(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzWp9().zzaB(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzWlo.zzZ2u(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzoB() != null ? this.zzoB().getCellFormat() : this.getCellFormat();
            border.zzZ2u(cellFormat);
        }
        this.zzWp9().zzYCC(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzWp9().clear();
    }

    private Node zzZVx() {
        Node node = this.zzZ2i != null && this.zzZ2i.getParentNode() == null ? this.zzX5u : this.zzZ2i;
        if (node != null && node.zzZiu() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzYck = this.zzYck && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzZsr(Node node) {
        this.zzZ2i = node;
        if (this.zzZ2i != null) {
            this.zzX5u = this.zzZ2i.getParentNode();
        }
        this.zzYck = false;
    }

    private zzZy2 zzXHo() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzXHo();
        }
        if (this.zzYgx == null) {
            this.zzYgx = new zzZy2();
        }
        return this.zzYgx;
    }

    private zzWme zzW6N() {
        if (this.zzZnh() != null && this.zzZnh().zzZ1g() == 1) {
            return this.zzXJc;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzW6N();
        }
        return this.zzXJc;
    }

    private zzW8S zzWp9() {
        if (this.zzZnh() != null && this.zzZnh().zzZ1g() != 3) {
            return this.zzZmW;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzXnD().zzWp9();
        }
        return this.zzZmW;
    }

    static final class zzZ2u {
        private zzhf zzWjs;
        private zzhf zzXY2;

        public zzZ2u(zzhf zzhf2, zzhf zzhf3) {
            this.zzWjs = zzhf2;
            this.zzXY2 = zzhf3;
        }

        public final zzhf zzYd6() {
            return this.zzWjs;
        }

        public final zzhf zzYVS() {
            return this.zzXY2;
        }
    }
}

