/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zz9j;
import com.aspose.words.internal.zzWlo;
import com.aspose.words.internal.zzX6r;
import com.aspose.words.internal.zzXDp;
import com.aspose.words.internal.zzZAU;
import com.aspose.words.internal.zzZoS;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzWd;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzW6G = new HashMap();
    private static HashMap<Integer, Integer> zzZGU = new HashMap();
    private static HashMap<Integer, Integer> zzWyu = new HashMap();
    private static HashMap<Integer, Integer> zzcJ = new HashMap();
    private static HashMap<Integer, Integer> zzYAt = new HashMap();
    private static HashMap<Integer, Integer> zzZfc = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzWlo.zzBF(fileName, "fileName");
        try (zzXDp zzXDp2 = zzWlo.zzZna(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzZou(zzXDp2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzZou(zzZoS.zzZ2u(stream));
    }

    static FileFormatInfo zzZou(zzZAU zzZAU2) throws Exception {
        if (zzZAU2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzWd zzWd2 = new zzWd();
            zzZAU zzZAU3 = zzZAU2;
            zzWd zzWd3 = zzWd2;
            return zzWd2.zz0l(zzZAU3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzBF(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzZU0(zzX6r.zzX6U(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzXiW(zzX6r.zzX6U(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zz9j.zzz(string = zzX6r.zzYZY(FileFormatUtil.zzYWw(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzZU0(FileFormatUtil.zzYg1(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzXiW(FileFormatUtil.zzYWw(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzX6r.zzYZY(FileFormatUtil.zzYg1(saveFormat));
        if (zz9j.zzz(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zzXiW(zzX6r.zzWvS(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzX6r.zzYZY(FileFormatUtil.zzWXi(imageType));
    }

    static Exception zzBF(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzrB(int n) {
        return zzX6r.toString(FileFormatUtil.zzYg1(n));
    }

    static int zzXiW(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWlo.zzZ2u(zzYAt, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzWOK(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWlo.zzZ2u(zzZfc, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzYL0(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzYWw(int n) {
        return zzWlo.zzZ2u(zzW6G, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzYg1(int n) {
        return zzWlo.zzZ2u(zzZGU, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzWXi(int n) {
        return zzWlo.zzZ2u(zzWyu, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZU0(int n) {
        return zzWlo.zzZ2u(zzcJ, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzYxE(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzWlo.zz0l(zzYAt, Integer.valueOf(n), Integer.valueOf(n2));
            zzWlo.zz0l(zzZGU, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzcJ.containsKey(n)) {
                zzWlo.zz0l(zzcJ, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzWlo.zz0l(zzW6G, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzWlo.zz0l(zzZfc, Integer.valueOf(n), Integer.valueOf(n4));
            zzWlo.zz0l(zzWyu, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzYxE(13, 10, 10, 1);
        FileFormatUtil.zzYxE(13, 0, 0, 1);
        FileFormatUtil.zzYxE(14, 11, 11, 1);
        FileFormatUtil.zzYxE(15, 20, 20, 1);
        FileFormatUtil.zzYxE(15, 0, 254, 1);
        FileFormatUtil.zzYxE(16, 21, 21, 1);
        FileFormatUtil.zzYxE(17, 22, 22, 1);
        FileFormatUtil.zzYxE(18, 23, 23, 1);
        FileFormatUtil.zzYxE(20, 24, 24, 1);
        FileFormatUtil.zzYxE(21, 25, 25, 1);
        FileFormatUtil.zzYxE(22, 26, 26, 1);
        FileFormatUtil.zzYxE(23, 27, 27, 1);
        FileFormatUtil.zzYxE(26, 30, 30, 1);
        FileFormatUtil.zzYxE(19, 31, 31, 1);
        FileFormatUtil.zzYxE(27, 50, 50, 1);
        FileFormatUtil.zzYxE(28, 45, 255, 1);
        FileFormatUtil.zzYxE(29, 51, 51, 1);
        FileFormatUtil.zzYxE(30, 54, 52, 1);
        FileFormatUtil.zzYxE(31, 0, 53, 1);
        FileFormatUtil.zzYxE(33, 53, 54, 1);
        FileFormatUtil.zzYxE(24, 60, 60, 1);
        FileFormatUtil.zzYxE(25, 61, 61, 1);
        FileFormatUtil.zzYxE(36, 40, 64, 1);
        FileFormatUtil.zzYxE(43, 47, 255, 1);
        FileFormatUtil.zzYxE(44, 48, 255, 1);
        FileFormatUtil.zzYxE(37, 41, 255, 1);
        FileFormatUtil.zzYxE(38, 46, 255, 1);
        FileFormatUtil.zzYxE(40, 42, 255, 1);
        FileFormatUtil.zzYxE(39, 44, 255, 1);
        FileFormatUtil.zzYxE(32, 52, 55, 1);
        FileFormatUtil.zzYxE(34, 70, 62, 1);
        FileFormatUtil.zzYxE(35, 73, 63, 1);
        FileFormatUtil.zzYxE(41, 71, 255, 1);
        FileFormatUtil.zzYxE(8, 100, 255, 1);
        FileFormatUtil.zzYxE(9, 105, 255, 10);
        FileFormatUtil.zzYxE(6, 101, 255, 6);
        FileFormatUtil.zzYxE(7, 102, 255, 7);
        FileFormatUtil.zzYxE(5, 104, 255, 5);
        FileFormatUtil.zzYxE(4, 0, 255, 4);
        FileFormatUtil.zzYxE(3, 0, 255, 3);
        FileFormatUtil.zzYxE(42, 72, 255, 1);
        FileFormatUtil.zzYxE(2, 103, 255, 2);
        FileFormatUtil.zzYxE(10, 106, 255, 8);
        FileFormatUtil.zzYxE(48, 80, 255, 1);
        FileFormatUtil.zzYxE(11, 107, 255, 9);
    }
}

