/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzWlo;
import com.aspose.words.internal.zzXg6;
import com.aspose.words.internal.zzYPN;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zz9c;
import com.aspose.words.zzXMZ;
import com.aspose.words.zzYGy;
import com.aspose.words.zzYdq;
import com.aspose.words.zzYqJ;
import com.aspose.words.zzZ4D;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzZYI;
    private Node zzXNB;
    private Node zzYgt;
    private int zzX1w;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzBF(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzZYI == null) {
            return null;
        }
        if (this.zzZYI.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzZYI;
    }

    final CompositeNode zzZ0y() {
        if (zzYqJ.zzX6U(this.getParentNode())) {
            return this.getParentNode().zzZ0y();
        }
        return this.getParentNode();
    }

    final CompositeNode zzVVU() {
        if (zzYqJ.zzX6U(this.getParentNode()) || zzYqJ.zzXzp(this.getParentNode())) {
            return this.getParentNode().zzVVU();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzZYI != null) {
            return this.zzZYI.getDocument();
        }
        return null;
    }

    final Document zzZ1v() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzXYJ() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzZKd();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzYgt;
    }

    final Node zzMf() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzYqJ.zzZjm((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzWUc() {
        Node node = zzYqJ.zzYCC(this.getPreviousSibling(), false);
        if (node == null && zzYqJ.zzX6U(this.getParentNode())) {
            node = this.getParentNode().zzWUc();
        }
        return node;
    }

    final Node zzYvf() {
        Node node = zzYqJ.zzlp(this.getNextSibling(), false);
        if (node == null && zzYqJ.zzX6U(this.getParentNode())) {
            node = this.getParentNode().zzYvf();
        }
        return node;
    }

    final CompositeNode zzWp() {
        Node node = this;
        while ((node = node.zzWUc()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzqR() {
        Node node = this;
        while ((node = node.zzYvf()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzXNB;
    }

    final Node zzXYj() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzYqJ.zzZjm((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzW3Y() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXGq() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzYgs() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzYqJ.zzYlv(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzXIn() {
        return this.zzXNB;
    }

    final void zzXbW(Node node) {
        this.zzXNB = node;
    }

    final Node zzZIw() {
        return this.zzYgt;
    }

    final void zzlo(Node node) {
        this.zzYgt = node;
    }

    final Node zzWpZ() {
        Node node = this;
        if (node.zzXNB != null) {
            node = this;
            return node.zzXNB;
        }
        return this.getParentNode();
    }

    final int zzZiu() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzYqJ.zzXXP(this);
        boolean bl2 = zzYqJ.zzZlC(this);
        boolean bl3 = zzYqJ.zzZ8Y(this);
        boolean bl4 = zzYqJ.zzYbD(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzZiu() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzZiu() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzZ2u(isCloneChildren, new zzZ2u(this));
    }

    Node zzZ2u(boolean bl, zzYGy zzYGy2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzZYI != null) {
            node.zzZYI = this.getDocument().zzd9();
        }
        node.zzXNB = null;
        node.zzYgt = null;
        if (zzYGy2 != null) {
            zzYGy2.zzYjU(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzYu0(StringBuilder stringBuilder) {
        zzWlo.zz0l(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    final zz9c zzYHa() {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            zz9c zz9c2 = zzWlo.zzZ2u((Object)compositeNode, zz9c.class);
            if (zz9c2 == null) continue;
            return zz9c2;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzWDv(Node node) {
        this.zzZYI = node != null ? node : this.getDocument().zzd9();
    }

    final void zzBF(DocumentBase documentBase) {
        this.zzZYI = documentBase != null ? documentBase.zzd9() : null;
    }

    final boolean zzYM3(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzYdl() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzWsA(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzW1I(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzYcZ(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzYu0(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzXYy(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    final Node zz8i(Node node) {
        return this.getParentNode().insertAfter(node, this);
    }

    final void zzXRn(Node node, Node node2) {
        this.getParentNode().zz0l(node, node2, this);
    }

    final Node zzDB(Node node) {
        return this.getParentNode().insertBefore(node, this);
    }

    final void zzZsr(Node node, Node node2) {
        this.getParentNode().zzZ2u(node, node2, this);
    }

    public String toString(int saveFormat) throws Exception {
        zzZ4D zzZ4D2 = zzYqJ.zzXjq(saveFormat);
        return zzZ4D2.zzZct(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZ4D zzZ4D2 = zzYqJ.zz0l(saveOptions);
        return zzZ4D2.zzZct(this);
    }

    final Node zzWmf(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzYqJ.zzRR(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzYdq zzZOU() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzYdq.zzVUZ(node);
        }
        return zzYdq.zzZNW(this.getParentNode());
    }

    final zzYdq zzZTS() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzYdq.zzZNW(node);
        }
        return zzYdq.zzVUZ(this.getParentNode());
    }

    final boolean zzZ37(Node node) {
        return Node.zzZH1(this, node);
    }

    final boolean zziy() {
        return this.getAncestor(1) == null;
    }

    static Node zzWqo(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzYPN<Node> zzYPN2 = Node.zzWln(node);
        zzYPN<Node> zzYPN3 = Node.zzWln(node2);
        return Node.zzZ2u(zzYPN2, zzYPN3);
    }

    static boolean zzZH1(Node node, Node node2) {
        zzYPN<Node> zzYPN2;
        if (node == null || node2 == null) {
            return false;
        }
        zzYPN<Node> zzYPN3 = Node.zzWln(node);
        Node node3 = Node.zzZ2u(zzYPN3, zzYPN2 = Node.zzWln(node2));
        if (node3 == null) {
            return false;
        }
        zzYPN<Node> zzYPN4 = zzYPN3;
        if (zzYPN4.size() == 0 || (zzYPN4 = zzYPN2).size() == 0) {
            zzYPN4 = zzYPN2;
            boolean bl = zzYPN4.size() > 0;
            return bl;
        }
        Object e = zzYPN3.peek();
        Object e2 = zzYPN2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzYPN<Node> zzWln(Node node) {
        zzYPN<Node> zzYPN2 = new zzYPN<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzYPN2.push(node2);
        }
        return zzYPN2;
    }

    private static Node zzZ2u(zzYPN<Node> zzYPN2, zzYPN<Node> zzYPN3) {
        Node node = null;
        while (zzYPN2.peek() == zzYPN3.peek()) {
            node = (Node)zzYPN2.pop();
            zzYPN3.pop();
            zzYPN<Node> zzYPN4 = zzYPN2;
            if (zzYPN4.size() != 0 && (zzYPN4 = zzYPN3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzX1w;
    }

    public void setCustomNodeId(int value) {
        this.zzX1w = value;
    }

    private String zzWSw() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzWlo.zzZ2u(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzXg6.zzVWL(stringBuilder.toString());
    }

    public String toString() {
        return zzXg6.zzVWL(zzXg6.zz0l("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzWSw()));
    }

    public void dd() {
    }

    final Node zzZy8(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzYlv(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzYgr(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzYlv(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzYlv(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzZ2u
    implements zzYGy {
        private Node zzZVH;
        private HashMap<Integer, Integer> zzWe5;

        zzZ2u(Node node) {
            this.zzZVH = node;
        }

        @Override
        public final void zzYjU(Node node, Node node2) {
            if (node == this.zzZVH) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzXMZ zzXMZ2 = (zzXMZ)((Object)node2);
            if (this.zzWe5 == null) {
                this.zzWe5 = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzWlo.zzZ2u(this.zzWe5, Integer.valueOf(zzXMZ2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzWg();
                zzWlo.zz0l(this.zzWe5, Integer.valueOf(zzXMZ2.getIdInternal()), Integer.valueOf(n));
            }
            zzXMZ2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzWlo.zzZ2u(this.zzWe5, Integer.valueOf(zzXMZ2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzXMZ2.setParentIdInternal(n2);
            }
        }
    }
}

