/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzZoS;
import com.aspose.words.zzVPO;
import com.aspose.words.zzWHQ;
import com.aspose.words.zzYMl;
import com.aspose.words.zzZEi;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzZEi,
Iterable<T> {
    private Node zzYo1;
    private CompositeNode zzY1J;
    private DocumentBase zzZSU;
    private boolean zzXXO;
    private int zzYIy;
    private int zzYLq;
    private Node zzWaQ;
    private int zzWBR;
    private zzVPO zzWyO;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzYMl.zz0M(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzYMl(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzVPO matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: container");
        }
        if (matcher == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: matcher");
        }
        this.zzY1J = container;
        this.zzZSU = container.getDocument();
        this.zzWyO = matcher;
        this.zzXXO = isDeep;
        this.zzZyT();
    }

    public Node get(int index) {
        try {
            this.zzZnu();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzYLq == index) {
                return this.zzWaQ;
            }
            int n = index - this.zzYLq;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzWlm(nodeCollection.zzWaQ, n);
            if (node != null) {
                this.zzYLq = index;
                this.zzWaQ = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzXXO) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzY1J.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzXXO) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzY1J.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzWxS();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzWHQ(this);
    }

    final <TNode extends Node> zzWHQ<TNode> zzXUQ() {
        return new zzWHQ(this);
    }

    final ArrayList<Node> zzJs() {
        return this.zzWxS();
    }

    final <TValue extends Node> ArrayList<TValue> zzWxS() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzZoS.zzZ2u(arrayList, node);
        }
        return arrayList;
    }

    private Node zzWlm(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zz3a(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzVUZ(curNode, true);
    }

    private Node zzVUZ(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzYo1 = node;
        do {
            node2 = this.zzYo1;
            Node node3 = this.zzXXO ? this.zzZ2u(true, this.zzYo1) : (this.zzYo1 = this.zzWyO.zzWXI() ? this.zzBF(true, this.zzYo1) : this.zz0l(true, this.zzYo1));
        } while (this.zzYo1 != null && !this.zzWyO.zzWlm(this.zzYo1));
        return node2;
    }

    private Node zz3a(Node node, boolean bl) throws Exception {
        while ((this.zzXXO ? this.zzZ2u(bl, node) : (node = this.zzWyO.zzWXI() ? this.zzBF(bl, node) : this.zz0l(bl, node))) != null && !this.zzWyO.zzWlm(node)) {
        }
        return node;
    }

    private Node zzZ2u(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzY1J);
        }
        return node.previousPreOrder(this.zzY1J);
    }

    private Node zz0l(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzY1J) {
                return this.zzY1J.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzY1J) {
            return this.zzY1J.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzBF(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzY1J ? this.zzY1J.zzZ07() : node.zzYvf();
        } else {
            Node node3 = node2 = node == this.zzY1J ? this.zzY1J.zzXZ6() : node.zzWUc();
        }
        if (node2 == this.zzY1J.getNextSibling() || node2 == this.zzY1J.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzZnu() {
        if (this.zzYIy != this.zzZzZ()) {
            this.zzZyT();
        }
    }

    private void zzZyT() {
        this.zzYIy = this.zzZzZ();
        this.zzYLq = -1;
        this.zzWaQ = this.zzY1J;
        this.zzWBR = -1;
    }

    private int zzZzZ() {
        if (this.zzZSU != null) {
            return this.zzZSU.zzYwv();
        }
        return 0;
    }

    public int getCount() {
        this.zzZnu();
        if (this.zzWBR == -1) {
            this.zzWBR = zzWHQ.zzZ2u(this);
        }
        return this.zzWBR;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYo1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzY1J;
    }
}

