/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzWw0;
import com.aspose.words.internal.zzX6r;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzZAw;
    private boolean zzXF6;
    boolean zzXTP = true;
    private boolean zzFB = true;
    private boolean zzWzw = false;
    private boolean zzH0;
    private boolean zzWYM = true;
    private boolean zzZSe;
    private String zzZj;
    private boolean zzWKu;
    private boolean zzZas = false;
    private int zzYQM = 1;
    private int zzXqE = 1;
    private int zzZVK = 0;
    private String zzZip = "";
    private boolean zz8A = true;
    private boolean zzXRi = true;
    private boolean zzWBu;
    private boolean zzH8;
    private int zzWRU = 0;
    private boolean zzZ7R = true;
    private boolean zzYb7 = false;

    protected SaveOptions() {
    }

    final boolean zzZoY() {
        return this.zzH0;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzVVg() {
        return false;
    }

    boolean zzZZZ() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzWYM;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzWYM = value;
    }

    public String getTempFolder() {
        return this.zzZj;
    }

    public void setTempFolder(String value) {
        this.zzZj = value;
    }

    public boolean getPrettyFormat() {
        return this.zzZSe;
    }

    public void setPrettyFormat(boolean value) {
        this.zzZSe = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzWKu;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzWKu = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzZas;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzZas = value;
    }

    public int getDmlRenderingMode() {
        return this.zzYQM;
    }

    public void setDmlRenderingMode(int value) {
        this.zzYQM = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzZVK;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzZVK = value;
    }

    public int getImlRenderingMode() {
        return this.zzXqE;
    }

    public void setImlRenderingMode(int value) {
        this.zzXqE = value;
    }

    public String getDefaultTemplate() {
        return this.zzZip;
    }

    public void setDefaultTemplate(String value) {
        this.zzZip = value;
    }

    public boolean getUpdateFields() {
        return this.zz8A;
    }

    public void setUpdateFields(boolean value) {
        this.zz8A = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzWBu;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzWBu = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzH8;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzH8 = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzYb7;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzYb7 = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzWzw;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzWzw = value;
    }

    final boolean zzCU() {
        return this.zzXRi;
    }

    final boolean zzWtW() {
        return this.zzZ7R;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzXiW(zzX6r.zzWvS(zzWw0.zzWg4(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzWRU;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzWRU = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzZAw;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzZAw = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzXF6;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzXF6 = value;
    }

    final boolean zzAr() {
        return this.zzFB;
    }

    final void zzFO(boolean bl) {
        this.zzFB = false;
    }
}

