/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SectionStart;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzWlo;
import com.aspose.words.internal.zzXg6;
import com.aspose.words.zzVZJ;
import com.aspose.words.zzYGy;
import com.aspose.words.zzZDK;

public final class Section
extends CompositeNode<Node>
implements zzZDK {
    private zzVZJ zzXK8;
    private PageSetup zzVWh;
    private HeaderFooterCollection zzYw8;

    public Section(DocumentBase doc) {
        this(doc, new zzVZJ());
    }

    Section(DocumentBase doc, zzVZJ sectPr) {
        super(doc);
        this.zzXK8 = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzYw8 == null) {
            this.zzYw8 = new HeaderFooterCollection(this);
        }
        return this.zzYw8;
    }

    public final PageSetup getPageSetup() {
        if (this.zzVWh == null) {
            Section section = this;
            this.zzVWh = new PageSetup(section, section.getDocument().zzXZi(), this.getDocument().getStyles(), new zzZ2u(this));
        }
        return this.zzVWh;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzk0();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzWqY(!value);
    }

    final zzVZJ zzXH8() {
        return this.zzXK8;
    }

    final void zz0l(zzVZJ zzVZJ2) {
        this.zzXK8 = zzVZJ2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzZ2u(boolean bl, zzYGy zzYGy2) {
        zzVZJ zzVZJ2;
        Section section = (Section)super.zzZ2u(bl, zzYGy2);
        zzVZJ zzVZJ3 = this.zzXK8;
        section.zzXK8 = zzVZJ2 = (zzVZJ)zzVZJ3.zzYCe();
        section.zzVWh = null;
        section.zzYw8 = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzYjU(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzYjU(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzlc(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzWgc(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzlc(n) == null;
            }
        }
        return false;
    }

    final void zzBF(Shape shape, boolean bl) throws Exception {
        this.zzZ2u(shape, 4, bl);
        this.zzZ2u(shape, 0, bl);
        this.zzZ2u(shape, 1, bl);
    }

    private void zzZ2u(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzXVK());
        shape2.setName(zzXg6.zz0l("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzYaO() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzXMf()) {
                if (!shape.zzoh()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zzYjU(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zz0l(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzXK8.zzXYK(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzXZi().zzYD7.zzWW1(key);
        }
        return zzVZJ.zzNR(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzXK8.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzXZi().zzYD7.zzYCC(key, value);
            return;
        }
        this.zzXK8.zzYCC(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzXK8.clear();
    }

    final boolean zzZmI() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzYO() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        Section section = this;
        objectArray[1] = SectionStart.toString(section.zzXK8.getSectionStart());
        return zzXg6.zz0l("{0} {1}", objectArray);
    }

    static final class zzZ2u
    implements zzZDK {
        private Section zzWIl;

        zzZ2u(Section section) {
            this.zzWIl = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zz5s().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zz5s().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zz5s().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZDK zz5s() {
            Document document = zzWlo.zzZ2u((Object)this.zzWIl.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzWIl;
        }
    }
}

