/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zz9j;
import com.aspose.words.internal.zzWlo;
import com.aspose.words.internal.zzXg6;
import com.aspose.words.internal.zzYrJ;
import com.aspose.words.internal.zzZem;
import com.aspose.words.internal.zziA;
import com.aspose.words.zzYlk;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzXAK;
    private zzYlk zz2t;

    Watermark(Document doc, zzYlk watermarkProvider) {
        this.zzXAK = doc;
        this.zz2t = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzXk9(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzZ2u(text, textWatermarkOptions, this.zzXAK);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzWlo.zz0l((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzXAK, 75);
        shape.getImageData().setImage(image);
        this.zzZ2u(shape, options, this.zzXAK);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzWlo.zz0l((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzXAK, 75);
        shape.getImageData().setImage(imagePath);
        this.zzZ2u(shape, options, this.zzXAK);
    }

    public final int getType() {
        Shape shape = this.zz2t.get();
        if (shape == null) {
            return 2;
        }
        shape.zzoh();
        if (shape.zzX9m()) {
            return 0;
        }
        if (shape.zz04()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zz2t.add(shape);
    }

    public final void remove() {
        this.zz2t.remove();
    }

    private static void zzXk9(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zz9j.zzUI(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzWlo.zzZ2u(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzZ2u(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zz0l(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zztT(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zz0l(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzZ28() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzW6V()) / d2) > (double)(f = pageSetup.zzYU6())) {
            d = (double)f / d3;
        }
        shape.zzYIg(zzZem.zzBF(d2 * d, 2, 1));
        shape.zzZcr(zzZem.zzBF(d3 * d, 2, 1));
    }

    private Shape zzZ2u(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzZ2u(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zztT(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzZ2u(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzYaF() ? 1.0f : textWatermarkOptions.getFontSize();
        zziA zziA2 = document.zzZs3().zzBF(shape.getTextPath().getFontFamily(), f, 0);
        long l = zziA2.zzZy8(shape.getTextPath().getText());
        if (textWatermarkOptions.zzYaF()) {
            l = Watermark.zzZ2u(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzYIg(zzZem.zzBF(Float.intBitsToFloat(n), 2, 1));
        shape.zzZcr(zzZem.zzBF(zzYrJ.zzWWJ(l), 2, 1));
    }

    private static long zzZ2u(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzW6V();
        float f2 = pageSetup.zzYU6();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzYrJ.zzWWJ(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzYrJ.zzWno(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzYrJ.zzWWJ(l) >= Float.intBitsToFloat(n)) {
            return zzYrJ.zzWno(f2 / f3, f2);
        }
        float f6 = f;
        return zzYrJ.zzWno(f6, f6 * f3);
    }

    private static void zztT(Shape shape, String string) {
        shape.setName(zzXg6.zz0l("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

