/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzUr;
import com.aspose.words.internal.zzVYL;
import com.aspose.words.internal.zzWoh;
import com.aspose.words.internal.zzYpc;
import com.aspose.words.internal.zzZN;
import com.aspose.words.internal.zzZav;
import com.aspose.words.internal.zzZme;
import com.aspose.words.internal.zzqM;
import com.aspose.words.internal.zzu;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzW0M
extends CertPathBuilderSpi {
    private final zzu zzWb2;
    private zzWoh zzMv;

    zzW0M(zzu zzu2) {
        this.zzWb2 = zzu2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzVYL pkixParams;
        if (params instanceof zzVYL) {
            pkixParams = (zzVYL)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzVYL.zzZ2u((PKIXBuilderParameters)params).zzYvl();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzVYL.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzUr zzUr2 = pkixParams.zzX9A().zzXtU();
        try {
            collection = zzZav.zzZ2u(zzUr2, pkixParams.zzX9A().zzYXi());
            collection.addAll(zzZav.zzZ2u(zzUr2, pkixParams.zzX9A().zzWVA()));
        }
        catch (zzWoh zzWoh2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzWoh2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzZ2u(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzMv != null) {
            throw new CertPathBuilderException(this.zzMv.getMessage(), this.zzMv.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzZ2u(X509Certificate x509Certificate, zzVYL zzVYL2, List list) throws CertPathBuilderException {
        zzYpc zzYpc2;
        zzZme zzZme2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzVYL2.zzWIC().contains(x509Certificate)) {
            return null;
        }
        if (zzVYL2.zzX2Y() != -1 && list.size() - 1 > zzVYL2.zzX2Y()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzZme2 = new zzZme(this.zzWb2);
            zzYpc2 = new zzYpc(this.zzWb2);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzZav.zzZ2u(x509Certificate, zzVYL2.zzX9A().zzPK(), zzVYL2.zzX9A().zzYny()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzZme2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzWoh("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzYpc2.engineValidate(certPath, zzVYL2);
                }
                catch (Exception exception) {
                    throw new zzWoh("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzqM> arrayList = new ArrayList<zzqM>();
            arrayList.addAll(zzVYL2.zzX9A().zzYXi());
            try {
                arrayList.addAll(zzZav.zzZ2u(x509Certificate.getExtensionValue(zzZN.zzZ2I.getId()), zzVYL2.zzX9A().zzWNw()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzWoh("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzZav.zzZ2u(x509Certificate, zzVYL2.zzX9A().zzWVA(), arrayList));
            }
            catch (zzWoh zzWoh2) {
                throw new zzWoh("Cannot find issuer certificate for certificate in certification path.", zzWoh2);
            }
            if (hashSet.isEmpty()) {
                throw new zzWoh("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzZ2u(x509Certificate2, zzVYL2, list);
            }
        }
        catch (zzWoh zzWoh3) {
            this.zzMv = zzWoh3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

