/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXg6;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzxU = new ArrayList();
    private final Map<String, DataColumn> zzXT0 = new HashMap<String, DataColumn>();
    private DataTable zzZrW;

    DataColumnCollection(DataTable table) {
        this.zzZrW = table;
    }

    public void add(DataColumn column) {
        if (zzXg6.zzWAW(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzXQ9(column.getColumnName());
        if (this.zzXT0.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzYjU(this.zzZrW);
        column.setOrdinal(this.zzxU.size());
        this.zzxU.add(column);
        this.zzXT0.put(string, column);
        this.zzZrW.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZrW);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZrW);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzXg6.zzWAW(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzXQ9(columnName);
        DataColumn dataColumn = this.zzXT0.get(string);
        if (dataColumn != null) {
            int n = this.zzxU.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzxU.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzxU.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzxU.remove(n);
            this.zzXT0.remove(DataColumnCollection.zzXQ9(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzZrW.getRows()) {
                dataRow.remove(n);
            }
            this.zzZrW.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzxU.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzxU.iterator();
    }

    public void clear() {
        this.zzXT0.clear();
        this.zzxU.clear();
    }

    final DataColumn[] zzZTV() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzxU);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzZ2u(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzxU.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzxU.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzXQ9(string);
            String string3 = DataColumnCollection.zzXQ9(dataColumn.getColumnName());
            this.zzXT0.remove(string3);
            this.zzXT0.put(string2, dataColumn);
            return;
        }
    }

    private static String zzXQ9(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

