/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXUI;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zz0l;
import com.aspose.words.net.System.Data.zzBF;
import com.aspose.words.net.System.Data.zzEh;
import com.aspose.words.net.System.Data.zzYCn;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzZb1;
    private final DataColumnCollection zz2m;
    private final ConstraintCollection zzsg;
    private final zzEh zzXSE;
    private ResultSet zzXT7;
    private String zzWGZ;
    private DataSet zzZek;
    private String zzYSx;
    private UniqueConstraint zzWOw;
    private boolean zzXEh;
    private final List<DataTableEventListener> zzWCK;
    private final Set<DataRow> zzYBT;
    private DataRelationCollection zzYsT;

    public DataTable() {
        this.zzZb1 = new DataRowCollection(this);
        this.zz2m = new DataColumnCollection(this);
        this.zzsg = new ConstraintCollection(this);
        this.zzXSE = new zzEh(this);
        this.zzYSx = "";
        this.zzXEh = true;
        this.zzWCK = new ArrayList<DataTableEventListener>();
        this.zzYBT = new HashSet<DataRow>();
        this.zzYsT = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzZb1 = new DataRowCollection(this);
        this.zz2m = new DataColumnCollection(this);
        this.zzsg = new ConstraintCollection(this);
        this.zzXSE = new zzEh(this);
        this.zzYSx = "";
        this.zzXEh = true;
        this.zzWCK = new ArrayList<DataTableEventListener>();
        this.zzYBT = new HashSet<DataRow>();
        this.zzYsT = new DataRelationCollection();
        this.zzWGZ = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zz0l.zzZ2u(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzZb1 = new DataRowCollection(this);
        this.zz2m = new DataColumnCollection(this);
        this.zzsg = new ConstraintCollection(this);
        this.zzXSE = new zzEh(this);
        this.zzYSx = "";
        this.zzXEh = true;
        this.zzWCK = new ArrayList<DataTableEventListener>();
        this.zzYBT = new HashSet<DataRow>();
        this.zzYsT = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzXT7 = resultSet;
        this.zzWGZ = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzXT7 != null) {
            if (this.zzXT7.getStatement() != null) {
                this.zzXT7.getStatement().getConnection().close();
            }
            this.zzXT7 = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzWGZ;
    }

    public void setTableName(String tableName) {
        this.zzWGZ = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zz2m.getCount();
    }

    public String getColumnName(int index) {
        return this.zz2m.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzXT7;
    }

    public DataSet getDataSet() {
        return this.zzZek;
    }

    final void zzYjU(DataSet dataSet) {
        this.zzZek = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzZek.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzYsT.add(dataRelation);
        }
        return this.zzYsT;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzZek.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzZb1;
    }

    public DataColumnCollection getColumns() {
        return this.zz2m;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzsg;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzWOw == null) {
            return new DataColumn[0];
        }
        return this.zzWOw.getColumns();
    }

    final void zzEh(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzWOw != null) {
                this.zzWOw.zzWlE(false);
                this.getConstraints().remove(this.zzWOw);
                this.zzWOw = null;
            }
            return;
        }
        if (this.zzWOw != null && DataColumn.areColumnSetsTheSame(value, this.zzWOw.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzZ2u(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzWOw != null) {
            this.zzWOw.zzWlE(false);
            this.getConstraints().remove(this.zzWOw);
            this.zzWOw = null;
        }
        UniqueConstraint.zzZ2u(this.getConstraints(), uniqueConstraint);
        this.zzWOw = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzYSx;
    }

    public void setNamespace(String namespace) {
        this.zzYSx = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXEh;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXEh = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzYBT.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zz0l.zzZ2u(this.getResultSet(), this);
            zz0l.zz0l(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzXUI.zzYjU(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zz0l.zztT(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzWCK.contains(listener)) {
            this.zzWCK.add(listener);
        }
    }

    public void removeEventListener(zzBF listener) {
        if (this.zzWCK.contains(listener)) {
            this.zzWCK.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzWCK.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzYBT.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWCK) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzYBT.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWCK) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzYBT.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWCK) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzWCK) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzWCK) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzYCn zzZ2u(zz0l[] zz0lArray) {
        DataColumn[] dataColumnArray = new DataColumn[zz0lArray.length];
        for (int i = 0; i < zz0lArray.length; ++i) {
            dataColumnArray[i] = zz0lArray[i].zzVWP();
        }
        DataTable dataTable = this;
        zzYCn zzYCn2 = dataTable.zzXSE.zzYjU(dataColumnArray);
        if (zzYCn2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzYCn2;
    }

    final zzEh zzZWM() {
        return this.zzXSE;
    }

    final Set<DataRow> zzYgn() {
        return this.zzYBT;
    }
}

