/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzx3;
import com.aspose.words.zzW7e;
import com.aspose.words.zzYBZ;
import com.aspose.words.zzYFj;
import com.aspose.words.zzYXI;
import com.aspose.words.zzYhB;
import com.aspose.words.zzZ0N;
import com.aspose.words.zzZYy;
import com.aspose.words.zzhv;
import com.aspose.words.zzif;
import com.aspose.words.zztn;

public class Cell
extends CompositeNode<Node>
implements zzYXI,
zztn {
    private zzZYy zzd6;
    private CellFormat zzVXj;
    private ParagraphCollection zzp2;
    private TableCollection zzWta;

    public Cell(DocumentBase doc) {
        this(doc, new zzZYy());
    }

    Cell(DocumentBase doc, zzZYy cellPr) {
        super(doc);
        this.zzd6 = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    public Cell getNextCell() {
        return (Cell)this.zzXDa();
    }

    public Cell getPreviousCell() {
        return (Cell)this.zzsc();
    }

    public Row getParentRow() {
        return (Row)this.zzZKi();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzYfT() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzXQ4(this, true);
        }
        return -1;
    }

    final int zzWIc() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzWIc();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzVXj == null) {
            this.zzVXj = new CellFormat(this);
        }
        return this.zzVXj;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzp2 == null) {
            this.zzp2 = new ParagraphCollection(this);
        }
        return this.zzp2;
    }

    public TableCollection getTables() {
        if (this.zzWta == null) {
            this.zzWta = new TableCollection(this);
        }
        return this.zzWta;
    }

    final zzZYy zzZsh() {
        return this.zzd6;
    }

    final void zzXsO(zzZYy zzZYy2) {
        this.zzd6 = zzZYy2;
    }

    @Override
    final Node zzXsO(boolean bl, zzW7e zzW7e2) {
        zzZYy zzZYy2;
        Cell cell = (Cell)super.zzXsO(bl, zzW7e2);
        zzZYy zzZYy3 = this.zzd6;
        cell.zzd6 = zzZYy2 = (zzZYy)zzZYy3.zzX6P();
        cell.zzVXj = null;
        cell.zzp2 = null;
        cell.zzWta = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellStart(this);
    }

    @Override
    public int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzif.zzZyv(this);
    }

    @Override
    final boolean zzW4B(Node node) {
        return zzYhB.zza4(node);
    }

    final int zzXg() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        for (Cell cell = row.getFirstCell(); cell != null; cell = cell.getNextCell()) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell != this) continue;
            return n;
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzd6.zzWNb(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzd6.zzWNb(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzZ0N zzZ0N2 = zzx3.zzXsO(object, zzZ0N.class);
        if (zzZ0N2 != null && zzZ0N2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzYmy(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzZYy.zzZip(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzd6.zzYGx(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzd6.clear();
    }

    private Object zzYmy(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzx3.zzXsO((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzXsO(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzhv getInsertRevision() {
        Cell cell = this;
        return cell.zzd6.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzhv value) {
        Cloneable cloneable = this;
        zzhv zzhv2 = value;
        cloneable = cloneable.zzd6;
        ((zzYBZ)cloneable).zzYGx(14, zzhv2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzhv getDeleteRevision() {
        Cell cell = this;
        return cell.zzd6.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzhv value) {
        Cloneable cloneable = this;
        zzhv zzhv2 = value;
        cloneable = cloneable.zzd6;
        ((zzYBZ)cloneable).zzYGx(12, zzhv2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYFj getMoveFromRevision() {
        Cell cell = this;
        return cell.zzd6.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzYFj value) {
        Cloneable cloneable = this;
        zzYFj zzYFj2 = value;
        cloneable = cloneable.zzd6;
        ((zzYBZ)cloneable).zzYGx(13, zzYFj2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYFj getMoveToRevision() {
        Cell cell = this;
        return cell.zzd6.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzYFj value) {
        Cloneable cloneable = this;
        zzYFj zzYFj2 = value;
        cloneable = cloneable.zzd6;
        ((zzYBZ)cloneable).zzYGx(15, zzYFj2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzd6.remove(13);
        cell = this;
        cell.zzd6.remove(15);
    }

    final zzZYy zzXkZ(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzZYy zzZYy2 = new zzZYy();
        this.zzXsO(3120, zzZYy2);
        this.zzXsO(3140, zzZYy2);
        this.zzXsO(3110, zzZYy2);
        this.zzXsO(3130, zzZYy2);
        this.zzXsO(3090, zzZYy2);
        this.zzXsO(3100, zzZYy2);
        this.zzXsO(3070, zzZYy2);
        this.zzXsO(3080, zzZYy2);
        if (bl && (tableStyle = zzx3.zzXsO((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzVQb(this, zzZYy2);
        }
        this.zzd6.zzVQb((zzYBZ)zzZYy2);
        return zzZYy2;
    }

    private void zzXsO(int n, zzZYy zzZYy2) {
        zzZYy2.zzYGx(n, this.fetchInheritedCellAttr(n));
    }
}

