/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CommentCollection;
import com.aspose.words.CommentRangeEnd;
import com.aspose.words.CommentRangeStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.InlineStory;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zzXX1;
import com.aspose.words.internal.zzZ1F;
import com.aspose.words.internal.zzx3;
import com.aspose.words.zzXq7;
import com.aspose.words.zzYFj;
import com.aspose.words.zzYMm;
import com.aspose.words.zzZvU;
import com.aspose.words.zzZyE;
import com.aspose.words.zzg8;
import java.util.ArrayList;
import java.util.Date;

public final class Comment
extends InlineStory
implements zzYMm,
zzg8 {
    private int zzYCF;
    private boolean zzZjF;
    private boolean zzZx7;
    private int zzVRX;
    private int zzGh = -1;
    private String zziD = "";
    private String zzYx7 = "";
    private zzZ1F zzZEF = zzZ1F.zzYmt;
    private zzZ1F zzYqQ = zzZ1F.zzYmt;
    private CommentCollection zzWOs;

    Comment(DocumentBase doc, zzZyE runPr) {
        super(doc, runPr);
        this.zzVRX = doc.zzXlt();
    }

    public Comment(DocumentBase doc) {
        this(doc, "", "", zzZ1F.zzYmt);
    }

    private Comment(DocumentBase doc, String author, String initial, zzZ1F dateTime) {
        this(doc, new zzZyE());
        this.setAuthor(author);
        this.setInitial(initial);
        zzZ1F zzZ1F2 = dateTime;
        Comment comment = this;
        this.zzZEF = zzZ1F2;
        this.getFont().setStyleIdentifier(39);
    }

    public Comment(DocumentBase doc, String author, String initial, Date dateTime) {
        this(doc, author, initial, zzZ1F.zzXsO(dateTime));
    }

    @Override
    public final int getNodeType() {
        return 19;
    }

    @Override
    public final int getStoryType() {
        return 4;
    }

    public final int getId() {
        return this.zzVRX;
    }

    public final void setId(int value) {
        this.zzVRX = value;
        if (this.getDocument() != null) {
            this.getDocument().zz8c();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getIdInternal() {
        return this.getId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setIdInternal(int value) {
        this.setId(value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getParentIdInternal() {
        return this.getParentId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setParentIdInternal(int value) {
        this.setParentId(value);
    }

    public final String getInitial() {
        return this.zziD;
    }

    public final void setInitial(String value) {
        zzx3.zzVQb((Object)value, "Initial");
        this.zziD = value;
    }

    public final Date getDateTime() {
        Comment comment = this;
        return zzZ1F.zzZhv(comment.zzZEF);
    }

    private void zzYqt(zzZ1F zzZ1F2) {
        this.zzZEF = zzZ1F2;
        if (!zzZ1F.zzXsO(this.zzYqQ, zzZ1F.zzYmt)) {
            this.zzYqQ = !zzZ1F.zzXsO(zzZ1F2, zzZ1F.zzYmt) ? zzZ1F2.zzaM() : zzZ1F.zzYmt;
        }
    }

    public final void setDateTime(Date value) {
        this.zzYqt(zzZ1F.zzXsO(value));
    }

    final zzZ1F zzwe() {
        if (!zzZ1F.zzXsO(this.zzYqQ, zzZ1F.zzYmt)) {
            return this.zzYqQ;
        }
        if (!zzZ1F.zzXsO(this.zzZEF, zzZ1F.zzYmt)) {
            return this.zzZEF.zzaM();
        }
        return zzZ1F.zzYmt;
    }

    public final Date getDateTimeUtc() {
        return zzZ1F.zzZhv(this.zzwe());
    }

    final void zzW0U(zzZ1F zzZ1F2) {
        this.zzYqQ = zzZ1F2;
    }

    public final String getAuthor() {
        return this.zzYx7;
    }

    public final void setAuthor(String value) {
        zzx3.zzVQb((Object)value, "Author");
        this.zzYx7 = value;
    }

    final zzZ1F zz3T() {
        return this.zzZEF;
    }

    final void zzYBZ(zzZ1F zzZ1F2) {
        this.zzZEF = zzZ1F2;
    }

    final boolean zzWwd() {
        return !zzZ1F.zzXsO(this.zzYqQ, zzZ1F.zzYmt);
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    private Comment zzXsO(String string, String string2, zzZ1F zzZ1F2, String string3) throws Exception {
        if (this.getParentId() != -1) {
            throw new IllegalStateException("Cannot add a reply to another reply.");
        }
        if (this.getParentNode() == null) {
            throw new IllegalStateException("No parent node.");
        }
        Comment comment = new Comment(this.getDocument(), string, string2, zzZ1F2);
        comment.setIdInternal(zzXq7.zzXsO(this.getDocument()));
        comment.setParentId(this.zzVRX);
        comment.setText(string3);
        Comment comment2 = this;
        Comment comment3 = zzx3.zzXsO((Object)this.zzXrq(), Comment.class);
        while (comment3 != null && comment3.getParentId() == this.zzVRX) {
            comment2 = comment3;
            comment3 = zzx3.zzXsO((Object)comment3.zzXrq(), Comment.class);
        }
        this.getParentNode().insertAfter(comment, comment2);
        zzZvU zzZvU2 = new zzZvU();
        if (zzZvU2.zzVQb(this.getDocument(), this.zzVRX)) {
            this.zzXsO(zzZvU2.zzZAf(), new CommentRangeStart(this.getDocument(), comment.getId()));
            this.zzXsO(zzZvU2.zzAx(), new CommentRangeEnd(this.getDocument(), comment.getId()));
        }
        return comment;
    }

    public final Comment addReply(String author, String initial, Date dateTime, String text) throws Exception {
        return this.zzXsO(author, initial, zzZ1F.zzXsO(dateTime), text);
    }

    private void zzXsO(CommentRangeStart commentRangeStart, CommentRangeStart commentRangeStart2) {
        Node node2;
        ArrayList arrayList = new ArrayList();
        for (Node node2 : this.getReplies()) {
            zzXX1.zzXsO(arrayList, Integer.valueOf(node2.getId()));
        }
        Object object = commentRangeStart;
        while (((Node)object).getNextSibling() != null && ((Node)(node2 = ((Node)object).getNextSibling())).getNodeType() == 33 && arrayList.contains(((CommentRangeStart)node2).getId())) {
            object = node2;
        }
        ((Node)object).zzVTs(commentRangeStart2);
    }

    private void zzXsO(CommentRangeEnd commentRangeEnd, CommentRangeEnd commentRangeEnd2) {
        ArrayList arrayList = new ArrayList();
        for (Node node : this.getReplies()) {
            if (((Comment)node).getId() == commentRangeEnd2.getId()) continue;
            zzXX1.zzXsO(arrayList, Integer.valueOf(((Comment)node).getId()));
        }
        Object object = commentRangeEnd;
        while (((Node)object).getNextSibling() != null) {
            int n;
            Node node;
            node = ((Node)object).getNextSibling();
            if (node.getNodeType() == 34) {
                n = ((CommentRangeEnd)node).getId();
            } else {
                if (node.getNodeType() != 19) break;
                n = ((Comment)node).getId();
            }
            if (!arrayList.contains(n) && n != this.zzVRX) break;
            object = node;
        }
        ((Node)object).zzVTs(commentRangeEnd2);
    }

    public final void removeReply(Comment reply) throws Exception {
        zzZvU zzZvU2 = new zzZvU();
        if (zzZvU2.zzVQb(this.getDocument(), reply.getId())) {
            zzZvU2.zzZAf().remove();
            zzZvU2.zzAx().remove();
        }
        reply.remove();
    }

    public final void removeAllReplies() throws Exception {
        for (Comment comment : this.getReplies().zzYLz()) {
            this.removeReply(comment);
        }
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentEnd(this);
    }

    public final void setText(String text) {
        this.removeAllChildren();
        Paragraph paragraph = new Paragraph(this.getDocument());
        paragraph.getParagraphFormat().setStyleIdentifier(30);
        this.appendChild(paragraph);
        DocumentBuilder documentBuilder = new DocumentBuilder(this.zzjO());
        documentBuilder.moveTo(paragraph);
        SpecialChar specialChar = new SpecialChar(this.zzjO(), '\u0005', new zzZyE());
        specialChar.getFont().setStyleIdentifier(39);
        documentBuilder.insertNode(specialChar);
        documentBuilder.write(text);
    }

    public final Comment getAncestor() {
        if (this.getDocument() == null || this.getParentId() == -1) {
            return null;
        }
        for (Comment comment : this.getDocument().getChildNodes(19, true)) {
            if (comment.getId() != this.getParentId()) continue;
            return comment;
        }
        return null;
    }

    public final CommentCollection getReplies() {
        if (this.zzWOs == null) {
            this.zzWOs = new CommentCollection(this.getDocument(), this);
        }
        return this.zzWOs;
    }

    public final boolean getDone() {
        return this.zzZx7;
    }

    public final void setDone(boolean value) {
        this.zzZx7 = value;
    }

    public final int getParentId() {
        return this.zzGh;
    }

    public final void setParentId(int value) {
        this.zzGh = value;
        if (this.getDocument() != null) {
            this.getDocument().zz8c();
        }
    }

    final int zzZUX() {
        return this.zzYCF;
    }

    final void zzXlT(int n) {
        this.zzYCF = n;
    }

    final boolean zzZYp() {
        return this.zzZjF;
    }

    final void zzWrF(boolean bl) {
        this.zzZjF = bl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzYFj getMoveFromRevision() {
        return this.zzXUK().getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveFromRevision(zzYFj value) {
        zzYFj zzYFj2 = value;
        zzZyE zzZyE2 = this.zzXUK();
        zzZyE2.zzYGx(13, zzYFj2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzYFj getMoveToRevision() {
        return this.zzXUK().getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveToRevision(zzYFj value) {
        zzYFj zzYFj2 = value;
        zzZyE zzZyE2 = this.zzXUK();
        zzZyE2.zzYGx(15, zzYFj2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void removeMoveRevisions() {
        this.zzXUK().remove(13);
        this.zzXUK().remove(15);
    }

    final String zzZm() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXN5(stringBuilder);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '\u0005') {
            stringBuilder.delete(0, 1);
        }
        return stringBuilder.toString();
    }
}

