/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzx3;
import com.aspose.words.zz0o;
import com.aspose.words.zz7v;
import com.aspose.words.zzW7e;
import com.aspose.words.zzXPv;
import com.aspose.words.zzYQO;
import com.aspose.words.zzYhB;
import com.aspose.words.zzZap;
import com.aspose.words.zzZcM;
import com.aspose.words.zzZdf;
import java.util.Iterator;

public abstract class CompositeNode<V extends Node>
extends Node
implements zz0o,
Iterable<V> {
    private Node zzXdg;
    private Node zzYvT;
    private Node zzZa3;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zz7v zz7v2 = new zz7v(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzZ28(this, true);
            return;
        }
        finally {
            zz7v2.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzXkj() {
        return this.zzXCg() != null;
    }

    final boolean zzW7z() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzYL0() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzZcM) {
                return true;
            }
            CompositeNode compositeNode = zzx3.zzXsO((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzYL0()) continue;
            return true;
        }
        return false;
    }

    public Node getFirstChild() {
        return this.zzXdg;
    }

    public Node getLastChild() {
        return this.zzYvT;
    }

    final Node zzXCg() {
        return zzYhB.zzZyM(this.getFirstChild(), false);
    }

    final Node zzY0g() {
        return zzYhB.zzYGx(this.getLastChild(), false);
    }

    final CompositeNode zzYbL() {
        return (CompositeNode)zzYhB.zzZyM(this.getFirstChild(), true);
    }

    final CompositeNode zzWDY() {
        return (CompositeNode)zzYhB.zzYGx(this.getLastChild(), true);
    }

    final Node zzWwY() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzYhB.zzX3y((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzWb6() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzYhB.zzX3y((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzXsO(boolean bl, zzW7e zzW7e2) {
        CompositeNode compositeNode = (CompositeNode)super.zzXsO(bl, zzW7e2);
        ((CompositeNode)super.zzXsO(bl, zzW7e2)).zzYvT = null;
        compositeNode.zzXdg = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzXoC(node.zzXsO(true, zzW7e2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXN5(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzXN5(StringBuilder stringBuilder) {
        this.zzIk(stringBuilder);
        zzx3.zzVQb(stringBuilder, this.zzXw5());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzVQb(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, bl);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzYhB.zzCZ(nodeType);
            Node node2 = node = bl ? this.zzXCg() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzoe() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzZdf.zzWRw(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzZdf.zzZ28(this, xpath);
    }

    @Override
    public Iterator<V> iterator() {
        return new zzYQO(this);
    }

    public <T extends Node> T appendChild(T newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public <T extends Node> T prependChild(T newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public <T extends Node> T insertAfter(T newChild, Node refChild) {
        return this.zzXsO(newChild, refChild, true);
    }

    public <T extends Node> T insertBefore(T newChild, Node refChild) {
        return this.zzXsO(newChild, refChild, false);
    }

    public <T extends Node> T removeChild(T oldChild) {
        return this.zzZ28(oldChild, false);
    }

    private <T extends Node> T zzZ28(T t, boolean bl) {
        if (t == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (t.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = zzYhB.zzXsO(documentBase, t, (Node)this, null, 1);
        DocumentBase documentBase2 = documentBase;
        if (documentBase2.zzWej() && zzYhB.zzZ5R(t)) {
            return t;
        }
        zzYhB.zzXsO(documentBase, nodeChangingArgs);
        if (!bl && zzYhB.zzX5i(t)) {
            zzYhB.zzYHi(t, false);
        }
        T t2 = this.zzYo(t);
        zzYhB.zzVQb(documentBase, nodeChangingArgs);
        return t2;
    }

    public void removeAllChildren() {
        zzZap.zzX5h(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzXoC(Node node) {
        node.getParentNode();
        if (this.zzYvT == null) {
            node.zzW4T(null);
            node.zzZlJ(null);
            this.zzXdg = node;
        } else {
            node.zzW4T(this.zzYvT);
            node.zzZlJ(null);
            this.zzYvT.zzZlJ(node);
        }
        this.zzYvT = node;
        node.zzJQ(this);
        return node;
    }

    final void zzXsO(Node node, Node node2, Node node3) {
        this.zzXsO(node, node2, node3, false);
    }

    final void zzXsO(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzW4B(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzVQb(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzXQ4(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzYhB.zzX3y(node3.getNodeType())) continue;
            if (zzYhB.zzXr0(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzXw5().length();
    }

    String zzXw5() {
        return "";
    }

    final String zzLz() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzIk(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzIk(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzXN5(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.acceptStart(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.acceptEnd(visitor));
    }

    public abstract int acceptStart(DocumentVisitor var1) throws Exception;

    public abstract int acceptEnd(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    boolean zzW4B(Node node) {
        return true;
    }

    final <T extends Node> T zzXsO(T t, Node node, boolean bl) {
        Object object;
        if (node != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (t == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (t == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzYWX(t)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (t == node) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = t.getDocument();
        zzYhB.zzVQb(documentBase, documentBase2);
        if (t.getNodeType() != 37 && !this.zzW4B(t)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = t.getParentNode();
        Node node2 = t.getNextSibling();
        if (compositeNode != null) {
            object = new zzXPv(documentBase);
            try {
                compositeNode.zzZ28(t, true);
            }
            finally {
                ((zzXPv)object).dispose();
            }
        }
        object = zzYhB.zzXsO(documentBase, t, null, (Node)this, 0);
        zzYhB.zzXsO(documentBase, (NodeChangingArgs)object);
        if (this.zzYvT == null) {
            t.zzW4T(null);
            t.zzZlJ(null);
            this.zzXdg = t;
            this.zzYvT = t;
        } else if (bl) {
            if (node != null) {
                this.zzVQb(t, node);
            } else {
                this.zzWRw(t, this.zzXdg);
            }
        } else if (node != null) {
            this.zzWRw(t, node);
        } else {
            this.zzVQb(t, this.zzYvT);
        }
        t.zzJQ(this);
        zzYhB.zzVQb(documentBase, (NodeChangingArgs)object);
        DocumentBase documentBase3 = documentBase;
        if (documentBase3.zzWej()) {
            zzYhB.zzXsO(t, compositeNode, node2);
        }
        return t;
    }

    private void zzVQb(Node node, Node node2) {
        Node node3 = node2.zzWSO();
        node.zzW4T(node2);
        node.zzZlJ(node3);
        node2.zzZlJ(node);
        if (node3 == null) {
            this.zzYvT = node;
            return;
        }
        node3.zzW4T(node);
    }

    private void zzWRw(Node node, Node node2) {
        Node node3 = node2.zzWH8();
        node.zzW4T(node3);
        node.zzZlJ(node2);
        node2.zzW4T(node);
        if (node3 == null) {
            this.zzXdg = node;
            return;
        }
        node3.zzZlJ(node);
    }

    private <T extends Node> T zzYo(T t) {
        if (t == this.zzXdg) {
            if (this.zzXdg == this.zzYvT) {
                this.zzXdg = null;
                this.zzYvT = null;
            } else {
                this.zzXdg = t.zzWSO();
                this.zzXdg.zzW4T(null);
            }
        } else {
            Node node = t.zzWH8();
            Node node2 = t.zzWSO();
            node.zzZlJ(node2);
            if (node2 == null) {
                this.zzYvT = node;
            } else {
                node2.zzW4T(node);
            }
        }
        t.zzZlJ(null);
        t.zzW4T(null);
        t.zzJQ(null);
        return t;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzZa3 = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzZa3;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

