/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.PageSet;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzWgE;
import com.aspose.words.internal.zzXN8;
import com.aspose.words.internal.zzXX1;
import com.aspose.words.internal.zzY3Q;
import com.aspose.words.internal.zzZAQ;
import com.aspose.words.internal.zzZTn;
import com.aspose.words.internal.zzx3;
import com.aspose.words.internal.zzyk;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class Converter {
    private Converter() {
    }

    public static void convert(String inputFile, String outputFile) throws Exception {
        String string = outputFile;
        Converter.convert(inputFile, string, SaveOptions.createSaveOptions(string));
    }

    public static void convert(String inputFile, String outputFile, int saveFormat) throws Exception {
        Converter.convert(inputFile, outputFile, SaveOptions.createSaveOptions(saveFormat));
    }

    public static void convert(String inputFile, String outputFile, SaveOptions saveOptions) throws Exception {
        String string = zzY3Q.zzXFV(outputFile);
        if (zzXN8.zzWS9(string) && !zzZAQ.zzW1I(string)) {
            zzZAQ.zzYYc(string);
        }
        try (zzZTn zzZTn2 = zzx3.zzN9(inputFile);){
            try (zzZTn zzZTn3 = zzx3.zzZNE(outputFile);){
                try {
                    Converter.zzXsO((zzWgE)zzZTn2, (zzWgE)zzZTn3, saveOptions);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("This document cannot be converted. Please contact Aspose.Words support.");
                }
            }
            return;
        }
    }

    private static void zzXsO(zzWgE zzWgE2, zzWgE zzWgE3, int n) throws Exception {
        Converter.zzXsO(zzWgE2, zzWgE3, SaveOptions.createSaveOptions(n));
    }

    public static void convert(InputStream inputStream, OutputStream outputStream, int saveFormat) throws Exception {
        Converter.zzXsO(zzWgE.zzVQb(inputStream), (zzWgE)zzWgE.zzWRw(outputStream), saveFormat);
    }

    private static void zzXsO(zzWgE zzWgE2, zzWgE zzWgE3, SaveOptions saveOptions) throws Exception {
        Document document = new Document(zzWgE2);
        document.zzXsO(zzWgE3, saveOptions);
    }

    public static void convert(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions) throws Exception {
        Converter.zzXsO(zzWgE.zzVQb(inputStream), (zzWgE)zzWgE.zzWRw(outputStream), saveOptions);
    }

    public static void convertToImages(String inputFile, String outputFile) throws Exception {
        SaveOptions saveOptions = SaveOptions.createSaveOptions(outputFile);
        Converter.convertToImages(inputFile, outputFile, saveOptions.getSaveFormat());
    }

    public static void convertToImages(String inputFile, String outputFile, int saveFormat) throws Exception {
        if (!Converter.zzYP2(saveFormat)) {
            throw new IllegalArgumentException("An invalid SaveFormat was chosen. Only Emf, WebP, Tiff, Png, Bmp, Jpeg, Svg, Gif and Eps image save formats are allowed");
        }
        Converter.convertToImages(inputFile, outputFile, new ImageSaveOptions(saveFormat));
    }

    public static void convertToImages(String inputFile, String outputFile, ImageSaveOptions saveOptions) throws Exception {
        String string = zzY3Q.zzXFV(outputFile);
        if (zzXN8.zzWS9(string) && !zzZAQ.zzW1I(string)) {
            zzZAQ.zzYYc(string);
        }
        try (zzZTn zzZTn2 = zzx3.zzN9(inputFile);){
            zzWgE[] zzWgEArray = Converter.zzXsO(zzZTn2, saveOptions);
            int n = 0;
            for (int n2 : saveOptions.getPageSet()) {
                if (n >= zzWgEArray.length) break;
                String string2 = zzY3Q.zzSg(outputFile) + "_" + n2 + FileFormatUtil.saveFormatToExtension(saveOptions.getSaveFormat());
                String string3 = zzY3Q.zzWb0(string, string2);
                try (zzWgE zzWgE2 = zzWgEArray[n];
                     zzZTn zzZTn3 = zzx3.zzZNE(string3);){
                    zzx3.zzVQb(zzWgE2, (zzWgE)zzZTn3);
                }
                ++n;
            }
            return;
        }
    }

    private static zzWgE[] zzYZ9(String string, int n) throws Exception {
        if (!Converter.zzYP2(n)) {
            throw new IllegalArgumentException("An invalid SaveFormat was chosen. Only Emf, WebP, Tiff, Png, Bmp, Jpeg, Svg, Gif and Eps image save formats are allowed");
        }
        return Converter.zzXsO(string, new ImageSaveOptions(n));
    }

    public static InputStream[] convertToImages(String inputFile, int saveFormat) throws Exception {
        return zzWgE.zzXsO(Converter.zzYZ9(inputFile, saveFormat));
    }

    private static zzWgE[] zzXsO(String string, ImageSaveOptions imageSaveOptions) throws Exception {
        try (zzZTn zzZTn2 = zzx3.zzN9(string);){
            zzWgE[] zzWgEArray = Converter.zzXsO(zzZTn2, imageSaveOptions);
            return zzWgEArray;
        }
    }

    public static InputStream[] convertToImages(String inputFile, ImageSaveOptions saveOptions) throws Exception {
        return zzWgE.zzXsO(Converter.zzXsO(inputFile, saveOptions));
    }

    private static zzWgE[] zzXOk(zzWgE zzWgE2, int n) throws Exception {
        if (!Converter.zzYP2(n)) {
            throw new IllegalArgumentException("An invalid SaveFormat was chosen. Only Emf, WebP, Tiff, Png, Bmp, Jpeg, Svg, Gif and Eps image save formats are allowed");
        }
        return Converter.zzXsO(zzWgE2, new ImageSaveOptions(n));
    }

    public static InputStream[] convertToImages(InputStream inputStream, int saveFormat) throws Exception {
        return zzWgE.zzXsO(Converter.zzXOk(zzWgE.zzVQb(inputStream), saveFormat));
    }

    private static zzWgE[] zzXsO(zzWgE zzWgE2, ImageSaveOptions imageSaveOptions) throws Exception {
        if (FileFormatUtil.zzXFi(zzWgE2).getLoadFormat() == 64) {
            throw new Exception("Pdf format is not supported for loading on Java platform");
        }
        return Converter.zzXsO(new Document(zzWgE2), imageSaveOptions);
    }

    public static InputStream[] convertToImages(InputStream inputStream, ImageSaveOptions saveOptions) throws Exception {
        return zzWgE.zzXsO(Converter.zzXsO(zzWgE.zzVQb(inputStream), saveOptions));
    }

    private static zzWgE[] zzVQb(Document document, int n) throws Exception {
        if (!Converter.zzYP2(n)) {
            throw new IllegalArgumentException("An invalid SaveFormat was chosen. Only Emf, WebP, Tiff, Png, Bmp, Jpeg, Svg, Gif and Eps image save formats are allowed");
        }
        return Converter.zzXsO(document, new ImageSaveOptions(n));
    }

    public static InputStream[] convertToImages(Document doc, int saveFormat) throws Exception {
        return zzWgE.zzXsO(Converter.zzVQb(doc, saveFormat));
    }

    private static zzWgE[] zzXsO(Document document, ImageSaveOptions imageSaveOptions) throws Exception {
        int n;
        ArrayList arrayList = new ArrayList();
        Iterator<Integer> iterator = imageSaveOptions.getPageSet().iterator();
        while (iterator.hasNext() && (n = iterator.next().intValue()) < document.getPageCount()) {
            ImageSaveOptions imageSaveOptions2 = imageSaveOptions.deepClone();
            imageSaveOptions2.setPageSet(new PageSet(n));
            zzyk zzyk2 = new zzyk();
            document.zzXsO((zzWgE)zzyk2, imageSaveOptions2);
            zzyk2.zzXoC(0L);
            zzXX1.zzXsO(arrayList, zzyk2);
        }
        zzWgE[] zzWgEArray = new zzWgE[]{};
        ArrayList arrayList2 = arrayList;
        return arrayList2.toArray(zzWgEArray);
    }

    public static InputStream[] convertToImages(Document doc, ImageSaveOptions saveOptions) throws Exception {
        return zzWgE.zzXsO(Converter.zzXsO(doc, saveOptions));
    }

    private static boolean zzYP2(int n) {
        return n == 103 || n == 107 || n == 100 || n == 101 || n == 102 || n == 104 || n == 44 || n == 105 || n == 106;
    }
}

