/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.List;
import com.aspose.words.ListCollection;
import com.aspose.words.ListLevel;
import com.aspose.words.Paragraph;
import com.aspose.words.internal.zzx3;
import com.aspose.words.zzVUH;
import com.aspose.words.zzXUb;
import com.aspose.words.zzYhB;

public class ListFormat {
    private zzVUH zzYV;
    private zzXUb zzZFX;
    private ListCollection zzXUa;
    private ListLevel zzZc7;
    private ListLevel zzZ9v;

    ListFormat(zzVUH parentParaAttrs, zzXUb parentRunAttrs, ListCollection lists) {
        this.zzYV = parentParaAttrs;
        this.zzZFX = parentRunAttrs;
        this.zzXUa = lists;
    }

    public void applyBulletDefault() {
        if (this.zzXUa.getCount() > 2046) {
            zzYhB.zzVQb(this.zzXUa.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzXjY(listFormat.zzXUa.add(0).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzZc7 = null;
    }

    public void applyNumberDefault() {
        if (this.zzXUa.getCount() > 2046) {
            zzYhB.zzVQb(this.zzXUa.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzXjY(listFormat.zzXUa.add(6).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzZc7 = null;
    }

    public void removeNumbers() {
        this.setList(null);
        ListFormat listFormat = this;
        this.zzZc7 = null;
    }

    public void listIndent() throws Exception {
        if (this.zzxJ() < 8) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.zzxJ() + 1);
            ListFormat listFormat2 = this;
            this.zzZc7 = null;
        }
    }

    public void listOutdent() throws Exception {
        if (this.zzxJ() > 0) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.zzxJ() - 1);
            ListFormat listFormat2 = this;
            this.zzZc7 = null;
        }
    }

    public int getListLevelNumber() {
        Document document = zzx3.zzXsO((Object)this.zzXUa.getDocument(), Document.class);
        if (document != null && document.getRevisionsView() == 1) {
            return this.zzZg3();
        }
        return this.zzxJ();
    }

    public void setListLevelNumber(int value) {
        this.zzYV.setParaAttr(1110, value);
        ListFormat listFormat = this;
        this.zzZc7 = null;
    }

    final int zzxJ() {
        return (Integer)this.zzYV.fetchParaAttr(1110);
    }

    final int zzZg3() {
        Paragraph paragraph = zzx3.zzXsO((Object)this.zzYV, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzZFf(1110, 1);
        }
        return this.zzxJ();
    }

    public boolean isListItem() {
        return this.getListId() != 0;
    }

    public List getList() {
        int n = this.getListId();
        if (n != 0) {
            return this.zzXUa.zzXgd(n);
        }
        return null;
    }

    public void setList(List value) {
        if (value == null) {
            this.zzXjY(0);
            this.setListLevelNumber(0);
        } else {
            if (value.getDocument() != this.zzXUa.getDocument()) {
                throw new IllegalArgumentException("The list belongs to a different document.");
            }
            if (value.isListStyleDefinition()) {
                throw new IllegalArgumentException("The list is a definition of a list style.");
            }
            this.zzXjY(value.getListId());
        }
        ListFormat listFormat = this;
        this.zzZc7 = null;
    }

    final List zzZQ9() {
        int n = this.zzYNZ();
        if (n != 0) {
            return this.zzXUa.zzXgd(n);
        }
        return null;
    }

    public ListLevel getListLevel() {
        try {
            Document document = zzx3.zzXsO((Object)this.zzXUa.getDocument(), Document.class);
            if (document != null && document.getRevisionsView() == 1) {
                return this.zzYrc();
            }
            return this.zzWAa();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private ListLevel zzWAa() {
        try {
            if (this.zzZc7 == null) {
                List list = this.getList();
                ListLevel listLevel = list != null ? list.zz18(this.zzxJ()) : null;
                this.zzZc7 = listLevel != null ? new ListLevel(listLevel, this.zzZFX) : null;
            }
            return this.zzZc7;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final ListLevel zzYrc() {
        if (this.zzZ9v == null) {
            List list = this.zzZQ9();
            ListLevel listLevel = list != null ? list.zz18(this.zzZg3()) : null;
            this.zzZ9v = listLevel != null ? new ListLevel(listLevel, this.zzZFX) : null;
        }
        return this.zzZ9v;
    }

    final int getListId() {
        return (Integer)this.zzYV.fetchParaAttr(1120);
    }

    private void zzXjY(int n) {
        Object object = this.zzYV.getDirectParaAttr(1160);
        int n2 = object != null ? (Integer)object : 0;
        int n3 = 0;
        if (n2 != 0 && n != 0 && this.getListLevel() != null && n2 < (n3 = this.getListLevel().zzE3().zzWUi() + this.getListLevel().zzE3().zzZ3G())) {
            n3 = 0;
        }
        this.zzYV.setParaAttr(1120, n);
        ListFormat listFormat = this;
        this.zzZc7 = null;
        if (n == 0 || object == null || this.getListLevel() == null) {
            return;
        }
        if (n2 == 0) {
            this.zzYV.removeParaAttr(1160);
            return;
        }
        int n4 = n2 - n3 + this.getListLevel().zzE3().zzWUi() + this.getListLevel().zzE3().zzZ3G();
        this.zzYV.setParaAttr(1160, n4);
    }

    private int zzYNZ() {
        Paragraph paragraph = zzx3.zzXsO((Object)this.zzYV, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzZFf(1120, 1);
        }
        return this.getListId();
    }
}

