/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzXm7;
import com.aspose.words.internal.zzY3Q;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzYTD;
    private boolean zzX0F;
    boolean zzWZR = true;
    private boolean zzNb = true;
    private boolean zzXvC = false;
    private boolean zzWSh;
    private boolean zzJX = true;
    private boolean zzY3Q;
    private String zzYIn;
    private boolean zzZqE;
    private boolean zzYSi = false;
    private int zzYJ9 = 1;
    private int zzXln = 1;
    private int zzXpv = 0;
    private String zzZc8 = "";
    private boolean zzXiZ = true;
    private boolean zzWB0 = true;
    private boolean zzWMs;
    private boolean zzWFX;
    private int zzWGX = 0;
    private boolean zzVRF = true;
    private boolean zzYiM = false;

    protected SaveOptions() {
    }

    final boolean zzYWp() {
        return this.zzWSh;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzPM() {
        return false;
    }

    boolean zzWmO() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzJX;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzJX = value;
    }

    public String getTempFolder() {
        return this.zzYIn;
    }

    public void setTempFolder(String value) {
        this.zzYIn = value;
    }

    public boolean getPrettyFormat() {
        return this.zzY3Q;
    }

    public void setPrettyFormat(boolean value) {
        this.zzY3Q = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzZqE;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzZqE = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzYSi;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzYSi = value;
    }

    public int getDmlRenderingMode() {
        return this.zzYJ9;
    }

    public void setDmlRenderingMode(int value) {
        this.zzYJ9 = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzXpv;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzXpv = value;
    }

    public int getImlRenderingMode() {
        return this.zzXln;
    }

    public void setImlRenderingMode(int value) {
        this.zzXln = value;
    }

    public String getDefaultTemplate() {
        return this.zzZc8;
    }

    public void setDefaultTemplate(String value) {
        this.zzZc8 = value;
    }

    public boolean getUpdateFields() {
        return this.zzXiZ;
    }

    public void setUpdateFields(boolean value) {
        this.zzXiZ = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzWMs;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzWMs = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzWFX;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzWFX = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzYiM;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzYiM = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzXvC;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzXvC = value;
    }

    final boolean zzZOr() {
        return this.zzWB0;
    }

    final boolean zzkM() {
        return this.zzVRF;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzZwQ(zzXm7.zzX5i(com.aspose.words.internal.zzY3Q.zzea(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzWGX;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzWGX = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzYTD;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzYTD = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzX0F;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzX0F = value;
    }

    final boolean zzZQg() {
        return this.zzNb;
    }

    final void zzZ8x(boolean bl) {
        this.zzNb = false;
    }
}

