/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SectionStart;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzXdc;
import com.aspose.words.internal.zzx3;
import com.aspose.words.zzW7e;
import com.aspose.words.zzWwt;
import com.aspose.words.zzZA7;
import com.aspose.words.zznM;
import java.util.ArrayList;

public final class Section
extends CompositeNode<Node>
implements zzWwt {
    private zznM zzWU8;
    private PageSetup zzXdI;
    private HeaderFooterCollection zzpK;

    public Section(DocumentBase doc) {
        this(doc, new zznM());
    }

    Section(DocumentBase doc, zznM sectPr) {
        super(doc);
        this.zzWU8 = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzpK == null) {
            this.zzpK = new HeaderFooterCollection(this);
        }
        return this.zzpK;
    }

    public final PageSetup getPageSetup() {
        if (this.zzXdI == null) {
            Section section = this;
            this.zzXdI = new PageSetup(section, section.getDocument().zzWl5(), this.getDocument().getStyles(), new zzXsO(this));
        }
        return this.zzXdI;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzeS();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzYZ0(!value);
    }

    final zznM zzZtR() {
        return this.zzWU8;
    }

    final void zzVQb(zznM zznM2) {
        this.zzWU8 = zznM2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzXsO(boolean bl, zzW7e zzW7e2) {
        zznM zznM2;
        Section section = (Section)super.zzXsO(bl, zzW7e2);
        zznM zznM3 = this.zzWU8;
        section.zzWU8 = zznM2 = (zznM)zznM3.zzX6P();
        section.zzXdI = null;
        section.zzpK = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzZ28(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzZ28(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        this.clearHeadersFooters(false);
    }

    public final void clearHeadersFooters(boolean preserveWatermarks) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            HeaderFooter headerFooter = (HeaderFooter)node;
            ArrayList arrayList = preserveWatermarks ? headerFooter.getChildNodes(18, true).zzYLz() : zzZA7.zzNS.zzYLz();
            headerFooter.removeAllChildren();
            for (Shape shape : arrayList) {
                if (!shape.zzZtp() && !shape.zzYQ2()) continue;
                headerFooter.appendChild(new Paragraph(this.getDocument()));
                headerFooter.getFirstParagraph().appendChild(shape);
            }
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzdw(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzW4B(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzdw(n) == null;
            }
        }
        return false;
    }

    final void zzWRw(Shape shape, boolean bl) throws Exception {
        this.zzXsO(shape, 4, bl);
        this.zzXsO(shape, 0, bl);
        this.zzXsO(shape, 1, bl);
    }

    private void zzXsO(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzYir());
        shape2.setName(zzXdc.zzVQb("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzWg8() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzWUy()) {
                if (!shape.zzWPl()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zzZ28(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzVQb(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzWU8.zzWNb(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzWl5().zzYMq.zzW1i(key);
        }
        return zznM.zzZip(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzWU8.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzWl5().zzYMq.zzYGx(key, value);
            return;
        }
        this.zzWU8.zzYGx(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzWU8.clear();
    }

    final boolean zzYWR() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzZV7() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        Section section = this;
        objectArray[1] = SectionStart.toString(section.zzWU8.getSectionStart());
        return zzXdc.zzVQb("{0} {1}", objectArray);
    }

    static final class zzXsO
    implements zzWwt {
        private Section zzWor;

        zzXsO(Section section) {
            this.zzWor = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzgV().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzgV().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzgV().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzWwt zzgV() {
            Document document = zzx3.zzXsO((Object)this.zzWor.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzWor;
        }
    }
}

