/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXdc;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintException;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzXr0;
import com.aspose.words.net.System.Data.zzZ28;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ConstraintCollection
implements Iterable<Constraint> {
    private final List<Constraint> zzWm1;
    private final DataTable zzZS6;
    private final AtomicInteger zzZve;

    ConstraintCollection(DataTable table) {
        this.zzZS6 = table;
        this.zzZve = new AtomicInteger(1);
        this.zzWm1 = new ArrayList<Constraint>();
    }

    public Constraint get(String constraintName) {
        if (zzXdc.zzVU8(constraintName)) {
            return null;
        }
        for (Constraint constraint : this.zzWm1) {
            if (!constraint.getConstraintName().equals(constraintName)) continue;
            return constraint;
        }
        return null;
    }

    public Constraint get(int idx) {
        return this.zzWm1.get(idx);
    }

    public void add(Constraint constraint) throws DataException, InvalidConstraintException {
        if (constraint == null) {
            return;
        }
        if (this == constraint.zzXfI()) {
            throw new IllegalArgumentException("Constraint already belongs to this collection.");
        }
        if (null != constraint.zzXfI()) {
            throw new IllegalArgumentException("Constraint already belongs to another collection.");
        }
        for (Constraint constraint2 : this) {
            if (!constraint2.equals(constraint)) continue;
            throw new DataException("Constraint matches contraint named '" + constraint2.getConstraintName() + "' already in collection");
        }
        if (this.zzXsO(constraint.getConstraintName(), null)) {
            throw new DataException("Constraint name already exists.");
        }
        constraint.addToConstraintCollectionSetup(this);
        if (constraint.getConstraintName() == null || "".equals(constraint.getConstraintName())) {
            constraint.setConstraintName(this.zzWq7());
        }
        constraint.zzXsO(this);
        this.zzWm1.add(constraint);
        if (constraint instanceof UniqueConstraint && ((UniqueConstraint)constraint).isPrimaryKey()) {
            this.zzZS6.setPrimaryKey(((UniqueConstraint)constraint).getColumns());
        }
    }

    public void remove(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        this.zzWm1.remove(constraint);
    }

    public boolean contains(Constraint cc) {
        if (cc != null) {
            return false;
        }
        return this.zzWm1.contains(cc);
    }

    public int getCount() {
        return this.zzWm1.size();
    }

    @Override
    public Iterator<Constraint> iterator() {
        return this.zzWm1.iterator();
    }

    final DataTable getTable() {
        return this.zzZS6;
    }

    final List<ForeignKeyConstraint> zz3A() {
        ArrayList<ForeignKeyConstraint> arrayList = new ArrayList<ForeignKeyConstraint>();
        for (Constraint constraint : this.zzWm1) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            arrayList.add((ForeignKeyConstraint)constraint);
        }
        return arrayList;
    }

    final void zzXsO(DataRow dataRow) throws ConstraintException, InvalidConstraintException {
        for (Constraint constraint : this.zzWm1) {
            if (constraint instanceof UniqueConstraint) {
                this.zzXsO((UniqueConstraint)constraint, dataRow);
            }
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            this.zzXsO((ForeignKeyConstraint)constraint, dataRow);
        }
    }

    private boolean zzXsO(String string, Constraint constraint) {
        for (Constraint constraint2 : this.zzWm1) {
            if (constraint2.equals(constraint) || zzXdc.zzXQ4(string, constraint2.getConstraintName(), false) != 0) continue;
            return true;
        }
        return false;
    }

    private String zzWq7() {
        return "Constraint" + this.zzZve.getAndIncrement();
    }

    private void zzXsO(UniqueConstraint uniqueConstraint, DataRow dataRow) throws ConstraintException {
        zzXr0 zzXr02 = this.zzZS6.zzXXp().zzZ28(uniqueConstraint.getColumns());
        Map<String, Object> map = zzXr02.zzXQ4(dataRow);
        if (map != null && !map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                stringBuilder.append(zzXdc.zzVQb("Column '{0}' is constrained to be unique.  Value '{1}' is already present.", entry.getKey(), entry.getValue()));
            }
            throw new ConstraintException(stringBuilder.toString());
        }
    }

    private void zzXsO(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) throws InvalidConstraintException {
        if (this.zzZS6.getDataSet() == null) {
            return;
        }
        DataRelationCollection dataRelationCollection = this.zzZS6.getDataSet().getRelations();
        if (dataRelationCollection.getCount() == 0) {
            return;
        }
        Object object = this;
        if (foreignKeyConstraint.getRelatedTable().getTableName().equals(((ConstraintCollection)object).zzZS6.getTableName())) {
            return;
        }
        object = this;
        if (!foreignKeyConstraint.getTable().getTableName().equals(((ConstraintCollection)object).zzZS6.getTableName())) {
            return;
        }
        if (!ConstraintCollection.zzVQb(foreignKeyConstraint, dataRow)) {
            DataTable dataTable = foreignKeyConstraint.getRelatedTable();
            DataRow dataRow2 = dataRow;
            DataColumn[] dataColumnArray = foreignKeyConstraint.getColumns();
            DataColumn[] dataColumnArray2 = foreignKeyConstraint.getRelatedColumns();
            object = dataTable;
            if (!zzZ28.zzXsO(dataTable, dataColumnArray2, dataColumnArray, dataRow2)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
                    stringBuilder.append(zzXdc.zzVQb("ForeignKeyConstraint '{0}' requires the child key values ('{1}') to exist in the parent table.", foreignKeyConstraint.getConstraintName(), dataRow.get(dataColumn)));
                }
                throw new InvalidConstraintException(stringBuilder.toString());
            }
        }
    }

    private static boolean zzVQb(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) {
        boolean bl = false;
        for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
            Object object = dataRow.get(dataColumn);
            if (object == null || object == DBNull.Value) continue;
            bl = true;
            break;
        }
        return !bl;
    }
}

