/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.batch.xjdbc;

import com.jn.langx.util.Preconditions;
import com.jn.sqlhelper.common.batch.BatchMode;
import com.jn.sqlhelper.common.batch.BatchResult;
import com.jn.sqlhelper.common.batch.BatchStatement;
import com.jn.sqlhelper.common.batch.BatchUpdater;
import com.jn.sqlhelper.common.statement.PreparedStatementSetter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class BatchSqlBatchUpdater<E, STATEMENT extends BatchStatement>
implements BatchUpdater<E, STATEMENT> {
    Connection connection;
    PreparedStatementSetter setter;

    @Override
    public BatchResult batchUpdate(STATEMENT statement, List<E> parameters) throws SQLException {
        Preconditions.checkNotNull(statement);
        Preconditions.checkArgument((statement.getBatchMode() == BatchMode.BATCH_SQL ? 1 : 0) != 0);
        PreparedStatement pstmt = this.connection.prepareStatement(statement.getSql());
        this.setter.setParameters(pstmt, 1, parameters);
        int updatedRows = pstmt.executeUpdate();
        BatchResult<E> result = new BatchResult<E>();
        result.setRowsAffected(updatedRows);
        result.setStatement((BatchStatement)statement);
        result.setParameters(parameters);
        return result;
    }
}

