/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.batch.xjdbc;

import com.jn.langx.util.Preconditions;
import com.jn.sqlhelper.common.batch.BatchMode;
import com.jn.sqlhelper.common.batch.BatchResult;
import com.jn.sqlhelper.common.batch.BatchStatement;
import com.jn.sqlhelper.common.batch.BatchUpdater;
import com.jn.sqlhelper.common.statement.PreparedStatementSetter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class SimpleBatchUpdater<E, STATEMENT extends BatchStatement>
implements BatchUpdater<E, STATEMENT> {
    Connection connection;
    PreparedStatementSetter<E> setter;

    @Override
    public BatchResult<E> batchUpdate(STATEMENT statement, List<E> parametersList) throws SQLException {
        Preconditions.checkNotNull(statement);
        Preconditions.checkArgument((statement.getBatchMode() == BatchMode.SIMPLE ? 1 : 0) != 0);
        int sum = 0;
        for (int i = 0; i < parametersList.size(); ++i) {
            PreparedStatement pstmt = this.connection.prepareStatement(statement.getSql());
            this.setter.setParameters(pstmt, 1, parametersList.get(i));
            int updated = pstmt.executeUpdate();
            sum += updated;
        }
        BatchResult<E> result = new BatchResult<E>();
        result.setStatement((BatchStatement)statement);
        result.setParameters(parametersList);
        result.setRowsAffected(sum);
        return result;
    }
}

