/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.connection;

import com.jn.easyjson.core.JSONBuilderProvider;
import com.jn.langx.configuration.Configuration;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.diff.MapDiffResult;
import com.jn.langx.util.function.Consumer2;
import com.jn.sqlhelper.common.connection.ConnectionConfiguration;
import java.util.Map;
import java.util.Properties;

public class NamedConnectionConfiguration
extends ConnectionConfiguration
implements Configuration,
Cloneable {
    private String name;

    public NamedConnectionConfiguration() {
    }

    public NamedConnectionConfiguration(ConnectionConfiguration configuration) {
        this.setDriver(configuration.getDriver());
        this.setUser(configuration.getUser());
        this.setPassword(configuration.getPassword());
        this.setUrl(configuration.getUrl());
        final Properties props = new Properties();
        Collects.forEach((Map)configuration.getDriverProps(), (Consumer2)new Consumer2<Object, Object>(){

            public void accept(Object key, Object value) {
                props.setProperty(key.toString(), value.toString());
            }
        });
        this.setDriverProps(props);
    }

    public void setId(String id) {
        this.name = id;
    }

    public String getId() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return JSONBuilderProvider.simplest().toJson((Object)this);
    }

    public boolean equals(Object obj) {
        Map map2;
        if (!(obj instanceof NamedConnectionConfiguration)) {
            return false;
        }
        NamedConnectionConfiguration o2 = (NamedConnectionConfiguration)obj;
        if (!(this.name.equals(o2.getName()) && this.getDriver().equals(o2.getDriver()) && this.getId().equals(o2.getId()) && this.getUrl().equals(o2.getUrl()) && this.getUser().equals(o2.getUser()))) {
            return false;
        }
        if (this.getPassword() != null ? !this.getPassword().equals(o2.getPassword()) : o2.getPassword() != null) {
            return false;
        }
        Map map1 = Collects.propertiesToStringMap((Properties)this.getDriverProps(), (boolean)true);
        MapDiffResult diffResult = Collects.diff((Map)map1, (Map)(map2 = Collects.propertiesToStringMap((Properties)o2.getDriverProps(), (boolean)true)));
        return diffResult.getAdds().isEmpty() && diffResult.getRemoves().isEmpty() && diffResult.getUpdates().isEmpty();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        NamedConnectionConfiguration conn = new NamedConnectionConfiguration(this);
        conn.setName(this.name);
        conn.setId(this.name);
        return conn;
    }
}

