/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.connection;

import com.jn.langx.configuration.ConfigurationSerializer;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import com.jn.sqlhelper.common.connection.NamedConnectionConfiguration;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesNamedConnectionConfigurationSerializer
implements ConfigurationSerializer<NamedConnectionConfiguration, String> {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesNamedConnectionConfigurationSerializer.class);

    public String serialize(NamedConnectionConfiguration configuration) {
        final Properties props = new Properties();
        props.setProperty("jdbc.driver", configuration.getDriver());
        props.setProperty("jdbc.url", configuration.getUrl());
        props.setProperty("jdbc.user", configuration.getUser());
        props.setProperty("jdbc.password", configuration.getPassword());
        Collects.forEach((Map)configuration.getDriverProps(), (Consumer2)new Consumer2<Object, Object>(){

            public void accept(Object key, Object value) {
                props.setProperty(key.toString(), value.toString());
            }
        });
        StringWriter stringWriter = new StringWriter();
        String comment = StringTemplates.formatWithPlaceholder((String)"JDBC Connection Configuration [{}]", (Object[])new Object[]{configuration.getId()});
        try {
            props.store(stringWriter, comment);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return stringWriter.toString();
    }
}

